
.486
.model	flat, stdcall
option casemap:none

include \masm32\include\windows.inc
include \masm32\include\kernel32.inc
include \masm32\include\user32.inc
include \masm32\include\bassmod.inc

include \masm32\macros\macros.asm

includelib \masm32\lib\kernel32.lib
includelib \masm32\lib\user32.lib
;includelib \masm32\lib\bassmod.lib

WinMain proto :DWORD,:DWORD,:DWORD,:DWORD
dialogproc proto :DWORD,:DWORD,:DWORD,:DWORD

.data

bleh db "mod",0 ; change this to whatever prefix you want
syntax db "%d",0
rsrctype db "BINARY",0
err db "can't read/write bassmod.dll",0
pathbuf db MAX_PATH dup(?)
buf db MAX_PATH dup(?)

; BASSMOD function names, add any others you'll need here
func1 db "BASSMOD_MusicPlay",0
func2 db "BASSMOD_Init",0
func3 db "BASSMOD_MusicLoad",0
func4 db "BASSMOD_Free",0
func5 db "BASSMOD_ErrorGetCode",0

.data?

hInstance dd ?
h dd ? ; module handle
fh dd ? ; file handle
w dd ? ; receives the number of written bytes
s dd ? ; size of resource (bassmod.dll)
buffer dd ?
resh dd ?

; BASSMOD function addresses, add any others you'll need here
BASSMOD_MusicPlay_addr dd ?
BASSMOD_Init_addr dd ?
BASSMOD_MusicLoad_addr dd ?
BASSMOD_Free_addr dd ?
BASSMOD_ErrorGetCode_addr dd ?

.code

start:

	invoke GetModuleHandle, NULL
	mov hInstance, eax

WinMain proc hinst:DWORD,hprev:DWORD,cmdline:DWORD,cmdshow:DWORD
	invoke DialogBoxParam,hInstance,1000,0,addr dialogproc,0
	invoke ExitProcess,0
	xor eax,eax
	ret
WinMain endp

InitBASSMOD proc
	invoke FindResource,hInstance,1101,addr rsrctype
	test eax,eax
	jz bail_out
	mov resh,eax
	invoke LoadResource,hInstance,resh
	invoke LockResource,eax
	test eax,eax
	jz bail_out
	mov buffer,eax
	invoke SizeofResource,hInstance,resh
	mov s,eax
	invoke GetTempPath,sizeof buf,addr buf
	test eax,eax
	jz bail_out
	invoke GetTempFileName,addr buf,addr bleh,0,addr buf
	test eax,eax
	jz bail_out
	invoke CreateFile,addr buf,GENERIC_WRITE,0,0,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,0
	cmp eax,-1
	je bail_out
	mov fh,eax
	invoke WriteFile,fh,buffer,s,addr w,0
	invoke CloseHandle,fh
	invoke LoadLibrary,addr buf
	test eax,eax
	jz bail_out
	mov h,eax

	; start retrieving addresses, add any other calls for addresses you want to retrieve here
	invoke GetProcAddress,h,addr func1
	mov BASSMOD_MusicPlay_addr,eax
	invoke GetProcAddress,h,addr func2
	mov BASSMOD_Init_addr,eax
	invoke GetProcAddress,h,addr func3
	mov BASSMOD_MusicLoad_addr,eax
	invoke GetProcAddress,h,addr func4
	mov BASSMOD_Free_addr,eax
	invoke GetProcAddress,h,addr func5
	mov BASSMOD_ErrorGetCode_addr,eax
	mov eax,1
	ret
bail_out:
	xor eax,eax
	ret
InitBASSMOD endp

dialogproc proc hwnd:DWORD,m:DWORD,wp:DWORD,l:DWORD
	LOCAL msg[5]:BYTE
	.if m==WM_COMMAND
		mov eax,wp
		.if ax==IDCANCEL
			invoke DestroyWindow,hwnd
		.elseif ax==IDOK
			call BASSMOD_MusicPlay_addr
		.endif
	.elseif m==WM_INITDIALOG
		invoke InitBASSMOD
		.if !eax
			invoke MessageBox,hwnd,addr err,addr err,MB_OK
			invoke ExitProcess,0
		.endif
		push 0
		push 44100
		push -1
		call BASSMOD_Init_addr
		invoke FindResource,hInstance,1100,addr rsrctype
		.if eax!=NULL
			invoke LoadResource,hInstance,eax
			invoke LockResource,eax
			.if eax!=NULL
				push BASS_MUSIC_LOOP or BASS_MUSIC_RAMPS or BASS_MUSIC_SURROUND
				push 0
				push 0
				push eax
				push 1
				call BASSMOD_MusicLoad_addr
				.if !eax
					call BASSMOD_ErrorGetCode_addr
					invoke wsprintf,addr msg,addr syntax,eax
					invoke MessageBox,hwnd,addr msg,addr msg,MB_OK
				.endif
			.endif
		.else
			invoke wsprintf,addr msg,addr syntax,FUNC(GetLastError)
			invoke MessageBox,hwnd,addr msg,addr msg,MB_OK
		.endif
		mov eax,1
		ret
	.elseif m==WM_DESTROY
		call BASSMOD_Free_addr
		invoke FreeLibrary,h
		invoke DeleteFile,addr buf
	.endif
	xor eax,eax
	ret
dialogproc endp

end start
