unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    ComboBox1: TComboBox;
    ComboBox2: TComboBox;
    Label1: TLabel;
    Label2: TLabel;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    ProgressBar1: TProgressBar;
    OpenDialog1: TOpenDialog;
    Button4: TButton;
    Button5: TButton;
    Timer1: TTimer;
    Memo1: TMemo;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure RadioButton2Click(Sender: TObject);
    procedure RadioButton1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses BassVideo, Bass;

{$R *.dfm}
var s : string;
    chan : DWORD;

function EncoderCallBack(Filter : HFilter; FilterName, FilterGuid : PChar; user : Pointer) : BOOL; stdcall;
begin
 TCombobox(user).Items.Add(FilterName);
 result := TRUE;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
 s := '';
 Bass_Init(-1, 44100, 0, Handle, nil);
 BassVideo_Init();
 ComboBox1.Clear;
 ComboBox2.Clear;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
 BassVideo_Free;
 Bass_Free;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
 if combobox1.Items.Count <> 0 then exit;
 BassVideo_EnumEncoder(EncoderType_Video, @EncoderCallBack, Combobox1);
 BassVideo_EnumEncoder(EncoderType_Audio, @EncoderCallBack, Combobox2);

end;

procedure TForm1.RadioButton2Click(Sender: TObject);
begin
 combobox1.Enabled := true;
 combobox2.Enabled := true;
end;

procedure TForm1.RadioButton1Click(Sender: TObject);
begin
 combobox1.Enabled := false;
 combobox2.Enabled := false;
end;


procedure VideoAction(Handle : DWORD; Action, param1, param2 : DWORD; param : POinter); stdcall;
begin
 case Action of
  BassVideo_OpenDone :
   begin
   end;
 else
  begin
   Form1.Memo1.Lines.Add(BassVideo_EventToString(param1));
   if param1 = $01 then//EC_COMPLETE = $01
    if chan <> 0 then
     begin
      BassVideo_Stop(chan);
      BassVideo_StreamFree(chan);
      chan := 0;
      Form1.ProgressBar1.Position := 0;
      Form1.Timer1.Enabled := FALSE;
      ShowMessage('Done');
     end;
  end;
 end;
end;

procedure TForm1.Button1Click(Sender: TObject);
var tg : string;
begin
 if not OpenDialog1.Execute then exit;
 s := OpenDialog1.FileName;
 if chan <> 0 then
  begin
    BassVideo_Stop(chan);
    BassVideo_StreamFree(chan);
  end;
 if radiobutton1.Checked then
  begin
   tg := 'C:\BassVideo.wmv';
   chan := BassVideo_EncoderVideo(PChar(s), PChar(tg), Video_WMV,
                                  BassVideo_FilterName, PChar(ComboBox1.Text),
                                  PChar(ComboBox2.Text), @VideoAction, nil);
  end
 else
  begin
   tg := 'C:\BassVideo.avi';
   chan := BassVideo_EncoderVideo(PChar(s), PChar(tg), Video_WMV,
                                  BassVideo_FilterName, PChar(ComboBox1.Text),
                                  PChar(ComboBox2.Text), @VideoAction, nil);
  end;

 
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
 BassVideo_ConfigEncoderFilter(chan,  EncoderType_WMASF, Handle);
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
 BassVideo_ConfigFilter(EncoderType_Video, PChar(Combobox1.Text), Handle);
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
 BassVideo_ConfigFilter(EncoderType_Audio, PChar(Combobox2.Text), Handle);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
 if chan <> 0 then
  begin
    BassVideo_Play(chan);
    Timer1.Enabled := TRUE;
  end;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var p, l : double;
begin
 l := BassVideo_GetLength(chan);
 p := BassVideo_GetPosition(chan);
 ProgressBar1.Position := Round((p / l) * 100);
end;

end.
