unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, Buttons, ImgList, ToolWin, ExtCtrls, Menus, StdCtrls,
  AppEvnts;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    StatusBar1: TStatusBar;
    ToolBar1: TToolBar;
    ImageList: TImageList;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    ToolButton7: TToolButton;
    SpeedButton1: TSpeedButton;
    ToolButton8: TToolButton;
    TrackBar2: TTrackBar;
    ToolButton1: TToolButton;
    OpenDialog1: TOpenDialog;
    VisTimer: TTimer;
    Timer1: TTimer;
    PopupMenu1: TPopupMenu;
    Source1: TMenuItem;
    N431: TMenuItem;
    N1691: TMenuItem;
    Free1: TMenuItem;
    ToolButton9: TToolButton;
    SoundLevel: TTrackBar;
    ToolButton10: TToolButton;
    SaveDialog1: TSaveDialog;
    N1: TMenuItem;
    Filter1: TMenuItem;
    ApplicationEvents1: TApplicationEvents;
    Label1: TLabel;
    TrackBar1: TTrackBar;
    Label2: TLabel;
    Button1: TButton;
    CheckBox1: TCheckBox;
    Button2: TButton;
    CheckBox2: TCheckBox;
    Label3: TLabel;
    TrackBar3: TTrackBar;
    Label4: TLabel;
    Bevel1: TBevel;
    CheckBox3: TCheckBox;
    Timer_Hide_Mouse: TTimer;
    N2: TMenuItem;
    DVDFunctions1: TMenuItem;
    PopupMenu2: TPopupMenu;
    OpenFile1: TMenuItem;
    OpenFilewithDualScreen1: TMenuItem;
    N3: TMenuItem;
    OpenDVD1: TMenuItem;
    OpenDVDFiles1: TMenuItem;
    OpenCaptureDevice1: TMenuItem;
    N4: TMenuItem;
    ExtractAudio1: TMenuItem;
    CheckBox4: TCheckBox;
    Timer_Show_Text: TTimer;
    Root1: TMenuItem;
    itleMenu1: TMenuItem;
    N5: TMenuItem;
    itle1: TMenuItem;
    NextChapter1: TMenuItem;
    PreviousChapter1: TMenuItem;
    N6: TMenuItem;
    ShowDVDCaption1: TMenuItem;
    AudioLanguage1: TMenuItem;
    Subtile1: TMenuItem;
    CameraAngle1: TMenuItem;
    OpenDialog2: TOpenDialog;
    ConvertVideo1: TMenuItem;
    OpenURL1: TMenuItem;
    Timer_Buffering: TTimer;
    Label5: TLabel;
    ComboBox1: TComboBox;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure FormDblClick(Sender: TObject);
    procedure VisTimerTimer(Sender: TObject);
    procedure SoundLevelChange(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure TrackBar2Change(Sender: TObject);
    procedure ToolButton5Click(Sender: TObject);
    procedure ToolButton2Click(Sender: TObject);
    procedure ToolButton4Click(Sender: TObject);
    procedure ToolButton1Click(Sender: TObject);
    procedure ToolButton3Click(Sender: TObject);
    procedure Source1Click(Sender: TObject);
    procedure N431Click(Sender: TObject);
    procedure N1691Click(Sender: TObject);
    procedure Free1Click(Sender: TObject);
    procedure ToolButton9Click(Sender: TObject);
    procedure ToolButton10Click(Sender: TObject);
    procedure ApplicationEvents1Message(var Msg: tagMSG;
      var Handled: Boolean);
    procedure CheckBox1Click(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure TrackBar3Change(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Timer_Hide_MouseTimer(Sender: TObject);
    procedure OpenFile1Click(Sender: TObject);
    procedure OpenFilewithDualScreen1Click(Sender: TObject);
    procedure ExtractAudio1Click(Sender: TObject);
    procedure Timer_Show_TextTimer(Sender: TObject);
    procedure OpenDVD1Click(Sender: TObject);
    procedure OpenDVDFiles1Click(Sender: TObject);
    procedure OpenCaptureDevice1Click(Sender: TObject);
    procedure ConvertVideo1Click(Sender: TObject);
    procedure OpenURL1Click(Sender: TObject);
    procedure Timer_BufferingTimer(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    isFullScreen, isURL : Boolean;
    OldRect : TRect;
    OldStyle : Longint;
    procedure WndProc(var Msg : TMessage); override;
    procedure ActiveSomeStuff;
    procedure WhenFormResize;

  end;

var
  Form1: TForm1;
  chan : DWORD;
  source : WideString;
  VEffect : BOOL;
  hText : integer;
  hThread : THandle;
function myVideoProc(Handle : DWORD; Action, param1, param2 : DWORD; user : Pointer): BOOL; stdcall;

implementation

uses BassVideo, bass, osc_vis, Unit2, Unit3, Unit4, convertdemoform,
  Unit6;

var Vis : TOcilloScope;
{$R *.dfm}
 isEncoder : BOOL = FALSE;
// wav function
// take from Bass "WriteWav" example
 i : longint;
 RecStream : TFileStream;
 nChannels       : Word;   // number of channels (i.e. mono, stereo, etc.)
 nSamplesPerSec  : DWORD;  // sample rate
 nAvgBytesPerSec : DWORD;
 nBlockAlign     : Word;
 wBitsPerSample  : Word;   // number of bits per sample of mono data
 chaninfo: BASS_CHANNELINFO;
 frq: Single;
 temp : string;
procedure CreateWav(OutFile : String);
var tg : integer;
begin
  BASS_ChannelGetInfo(chan, chaninfo);
	nChannels := chaninfo.chans;
  if (chaninfo.flags and BASS_SAMPLE_8BITS > 0) then
    wBitsPerSample := 8
  else
    wBitsPerSample := 16;

	nBlockAlign := nChannels * wBitsPerSample div 8;
	BASS_ChannelGetAttribute(chan, BASS_ATTRIB_FREQ, frq);
  nSamplesPerSec := Trunc(frq);
	nAvgBytesPerSec := nSamplesPerSec * nBlockAlign;

    tg := 0;
    repeat
    if fileexists(OutFile) then
     OutFile := 'C:\BassVideo' + inttostr(tg) + '.wav';
    inc(tg);
    until not fileexists(OutFile);
    RecStream := TFileStream.Create(OutFile, fmCreate);
    ShowMessage('Wav file output to : ' + OutFile);
 // Write header portion of wave file
    temp := 'RIFF'; RecStream.write(temp[1], length(temp));
    temp := #0#0#0#0; RecStream.write(temp[1], length(temp));   // File size: to be updated
    temp := 'WAVE'; RecStream.write(temp[1], length(temp));
    temp := 'fmt '; RecStream.write(temp[1], length(temp));
    temp := #$10#0#0#0; RecStream.write(temp[1], length(temp)); // Fixed
    temp := #1#0; RecStream.write(temp[1], length(temp));       // PCM format
    if nChannels = 1 then
       temp := #1#0
    else
       temp := #2#0;
    RecStream.write(temp[1], length(temp));
    RecStream.write(nSamplesPerSec, 2);
    temp := #0#0; RecStream.write(temp[1], length(temp));   // SampleRate is given as dWord
    RecStream.write(nAvgBytesPerSec, 4);
    RecStream.write(nBlockAlign, 2);
    RecStream.write(wBitsPerSample, 2);
    temp := 'data'; RecStream.write(temp[1],length(temp));
    temp := #0#0#0#0; RecStream.write(temp[1],length(temp)); // Data size: to be updated
end;

procedure WriteWav(Buffer : Pointer; Size : DWORD);
begin
 RecStream.Write(buffer^, Size);
end;

procedure EndWav;
begin
   i := RecStream.Size - 8;    // size of file
   RecStream.Position := 4;
   RecStream.write(i, 4);
   i := i - $24;               // size of data
   RecStream.Position := 40;
   RecStream.write(i, 4);
   RecStream.Free;
end;
//end of writewav function

// function to convert time to string data
function FormatNum(i, num : integer): string;
begin
 str(i, result);
 while length(result) < num do result := '0' + result;
end;

function TimeToStr5(sec : Double) : string;
var Hours, Minutes, Seconds : Double;
begin
  Hours := Trunc(sec / 3600);
  sec := sec - (Hours * 3600);
  Minutes := Trunc(sec / 60);
  sec := sec - (Minutes * 60);
  Seconds := Trunc(sec);
//  sec := (sec - Seconds) * 1000;
  Result := FormatNum(Trunc(Hours), 2) + ':' + FormatNum(Trunc(Minutes), 2) + ':'
           + FormatNum(Trunc(Seconds), 2);// + ':' + FormatNum(Trunc(sec), 3);
end;

function myVideoProc(Handle : DWORD; Action, param1, param2 : DWORD; user : Pointer): BOOL; stdcall;
var R : TRect;
begin
 result := TRUE; // handle all event my self
 case Action of
  BassVideo_FoundVideo :
    begin
      R := Form1.ClientRect;
      R.Left := 0;
      R.Top := 0;
      R.Bottom := R.Bottom - Form1.Panel1.Height - Form1.StatusBar1.Height;
      BASSVideo_SetVideoWindow(Handle, Form1.Handle, R, 0);
    end;
  BassVideo_EndStream :
   begin
    if isEncoder then
     begin
      EndWav;
    //  BassVideo_StreamFree(chan);
     end;
    Form3.Memo1.Lines.Add('End of stream...');
   end;
  BassVideo_Buffering :
   begin
    if param1 = 0 then
     Form1.Timer_Buffering.Enabled := FALSE
    else
     Form1.Timer_Buffering.Enabled := TRUE;
   end;
  BassVideo_OpenDone :
    begin
    Form3.Memo1.Lines.Add('Open done.');
    end;
  BassVideo_DShow_Event :
   begin
    Form3.Memo1.Lines.Add(BassVideo.BassVideo_EventToString(integer(param1)));
    
   end;
 end;
end;

function ThreadPlay(p : Pointer): integer;
begin
 BassVideo_Play(chan);
{ Form1.Timer_Show_Text.Enabled := FALSE;
 Form1.VisTimer.Enabled := FALSE;
 Form1.Timer1.Enabled := FALSE;}
 PostMessage(Form1.Handle, WM_USER + 2, 0, 0);
 result := 0;
end;
{ TForm1 }
procedure TForm1.WndProc(var Msg: TMessage);
var id : DWORD;
    ps : TPaintStruct;
    dc : HDC;
begin
  if chan <> 0 then
  case Msg.Msg of
   WM_MOVE  : begin
                // apply for Windowed Renderer
                BassVideo_WindowMove(chan, Msg.Msg, Msg.WParam, Msg.LParam, 0);
              end;

   WM_SIZE  : begin
               WhenFormResize;
              end;
   WM_PAINT : begin
                 dc := BeginPaint(Handle, ps);
                 BASSVideo_Repaint(chan, Handle, DC, 0);
                 EndPaint(Handle, ps);
              end;
   WM_MOUSEMOVE : BassVideo_DVD_MouseMove(chan, msg.LParam);
   WM_LBUTTONUP : BassVideo_DVD_MouseClick(chan, msg.LParam);
   WM_USER + 2 : begin
                  CloseHandle(hThread);
                  Form1.ActiveSomeStuff;
                 end;
   WM_USER + 1 :
     begin
       CloseHandle(hThread);
       if chan <> 0 then
        begin
         BassVideo_ReAddVideo(chan);
         hThread := CreateThread(nil, 0, @ThreadPlay, nil, 0, id);
         Timer_Buffering.Enabled := TRUE;
        end
       else
        ShowMessage('Open URL Failed!');
     end;
  end;
   inherited;
end;

procedure TForm1.FormCreate(Sender: TObject);
var R : TRect;
begin
 source := '';
 Bass_Init(-1, 44100, 0, Handle, nil);
 BassVideo_Init();
 R := Form1.ClientRect;
 R.Left := 0; R.Top := 0;
 if Panel1.Visible then
 R.Bottom := R.Bottom - Form1.Panel1.Height - Form1.StatusBar1.Height;
 BassVideo_SetVideoWindow(0, Handle,  R, 0);
 isURL := FALSE;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
 BassVideo_Free;
 Bass_Free;
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
var P : TPoint;
begin
 GetCursorPos(P);
 PopupMenu2.Popup(P.X, P.Y);
end;

procedure TForm1.FormDblClick(Sender: TObject);
begin
 isFullScreen := not isFullScreen;
 if isFullScreen then
  begin
    StatusBar1.Hide;
    Panel1.Hide;
    OldRect.Left := Left;
    OldRect.Top := Top;
    OldRect.Right := Width;
    OldRect.Bottom := Height;
    OldStyle := GetWindowLong(Handle, GWL_STYLE);
    SetWindowLong(Handle, GWL_STYLE, integer(WS_POPUPWINDOW or WS_VISIBLE));
    Left := -1;
    Top := -1;
    Height := Screen.Height + 2;
    Width := Screen.Width + 2;
    Timer_Hide_Mouse.Enabled := TRUE;
    Form3.Hide;
  end
 else
  begin
   StatusBar1.Show;
   Panel1.Show;
   Form3.Show;
   SetWindowLong(Handle, GWL_STYLE, OldStyle);
   SetWindowPos(Handle, 0, OldRect.Left , OldRect.Top, OldRect.Right, OldRect.Bottom , 0);
   Form1.Cursor := crDefault;
  end;
end;

procedure TForm1.VisTimerTimer(Sender: TObject);
var Data : TWaveData;
begin
 if Timer_Buffering.Enabled then exit;
 if (chan = 0) or (isEncoder) then exit;
 if isURL then exit;
 if vis = nil then
   Vis := TOcilloScope.Create(Form3.PaintBox1.Width, Form3.PaintBox1.Height);
 Bass_ChannelGetData(chan, @Data, 2048 + 1);
 Vis.Draw(Form3.PaintBox1.Canvas.Handle, Data, 0, Form3.PaintBox1.Height div 2);
end;

procedure TForm1.SoundLevelChange(Sender: TObject);
begin
 if isURL then
  BassVideo_SetVolume(chan, round(SoundLevel.Position / 100))
 else
  BASS_ChannelSetAttribute(chan, BASS_ATTRIB_VOL, SoundLevel.Position / 10000);
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var p : Double;
begin
 if Timer_Buffering.Enabled then exit;
 if chan = 0 then exit;
 p := BASSVideo_GetPosition(chan);
 TrackBar2.OnChange := nil;
 TrackBar2.Position := Round(p);
 TrackBar2.Max := Round(BassVideo_GetLength(chan));
 TrackBar2.OnChange := TrackBar2Change;
 StatusBar1.Panels[0].Text := TimeToStr5(p) + ' / ' + TimeToStr5(TrackBar2.Max);
end;

procedure TForm1.TrackBar2Change(Sender: TObject);
begin
 BassVideo_SetPosition(chan, Form1.TrackBar2.Position);
end;

function FilterProc(Handle : DWORD; FilterName : PChar; Filter : Pointer; User : Pointer): BOOL; stdcall;
var mt : TMenuItem;
begin
 result := TRUE;
 mt := TMenuItem.Create(Form1);
 mt.Caption := FilterName;
 mt.Enabled := BassVideo.BassVideo_HasFilterPropertyPage(Handle, Filter, 0); //
 Form1.Filter1.Insert(0, mt);
end;

procedure TForm1.ActiveSomeStuff;
var p : Double;
    i : integer;
begin
 p := BASSVideo_GetLength(chan);
 TrackBar2.Max := Round(p);
 TrackBar2.Frequency := Round(p/100);
 TrackBar2.Min := 0;
 SoundLevelChange(nil); // set vol
 // Enum all filter in the graph and show it for user
 for i := 0 to Filter1.Count - 1 do
  Filter1.Delete(0);
 BassVideo.BassVideo_EnumFilter(chan, @FilterProc, nil);
 CheckBox1Click(nil);
 CheckBox2Click(nil);
end;

procedure TForm1.ToolButton5Click(Sender: TObject);
begin
 TrackBar2.Position := TrackBar2.Position + 5;
end;

procedure TForm1.ToolButton2Click(Sender: TObject);
begin
 if Bass_ChannelIsActive(chan) = BASS_ACTIVE_PLAYING then
  BassVideo_Pause(chan)
 else
  BassVideo_Play(chan);
end;

procedure TForm1.ToolButton4Click(Sender: TObject);
begin
 BassVideo_Stop(chan)
end;

procedure TForm1.ToolButton1Click(Sender: TObject);
begin
 TrackBar2.Position := TrackBar2.Position - 5;
end;

procedure TForm1.ToolButton3Click(Sender: TObject);
begin
 BassVideo_Play(chan);
end;

procedure TForm1.Source1Click(Sender: TObject);
begin
 BassVideo_SetRatio(chan, RSource, 0, 0);
 WhenFormResize; // should call it if you use windowed mode
end;

procedure TForm1.WhenFormResize;
var R : TRect;
begin
  R := Form1.ClientRect;
  R.Left := 0; R.Top := 0;
  if Panel1.Visible then
  R.Bottom := R.Bottom - Form1.Panel1.Height - Form1.StatusBar1.Height;
  BassVideo_WindowResize(chan, R, 0);
end;

procedure TForm1.N431Click(Sender: TObject);
begin
 BassVideo_SetRatio(chan, R43, 0, 0);
 WhenFormResize; // should call it if you use windowed mode

end;

procedure TForm1.N1691Click(Sender: TObject);
begin
 BassVideo_SetRatio(chan, R169, 0, 0);
 WhenFormResize; // should call it if you use windowed mode

end;

procedure TForm1.Free1Click(Sender: TObject);
begin
 BassVideo_SetRatio(chan, RFree, 0, 0);
 WhenFormResize; // should call it if you use windowed mode

end;

procedure TForm1.ToolButton9Click(Sender: TObject);
begin
 BassVideo_Pause(chan);
 BassVideo_FrameStep(chan)
end;

procedure TForm1.ToolButton10Click(Sender: TObject);
var s : widestring;
    pos : Double;
begin
 if chan = 0 then exit;
 pos := BassVideo_GetPosition(chan);
 if not SaveDialog1.Execute then exit;
 s := SaveDialog1.FileName;
 BassVideo.BassVideo_CaptureBitmap(PWideChar(source), pos, PWideChar(s), BASS_UNICODE); // use unicode file name
end;

procedure TForm1.ApplicationEvents1Message(var Msg: tagMSG;
  var Handled: Boolean);
  var id, i : integer;
begin
 if Msg.message = WM_COMMAND  then
             begin
              id := Msg.WParam;
              for i := 0 to Filter1.Count - 1 do
               begin
                if Filter1.Items[i].Command = id then
                 if Filter1.Items[i].Enabled then
                 begin
                   BassVideo.BassVideo_ShowFilterPropertyPage(chan, PChar(Filter1.Items[i].Caption), Handle, BASSVIDEO_FILTERNAME);
                   exit;
                 end;
               end;
             end;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
 if chan <> 0 then
  begin
    BassVideo.BassVideo_SetTempoEnable(chan, checkbox1.Checked);
    TrackBar1Change(nil);
  end;
end;

procedure TForm1.TrackBar1Change(Sender: TObject);
begin
 Label2.Caption := inttostr(Trackbar1.Position);
 if chan <> 0 then
 BassVideo.BassVideo_SetTempoValue(chan, Trackbar1.Position)
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
 trackbar1.Position := 1000;
end;

procedure TForm1.TrackBar3Change(Sender: TObject);
begin
 Label3.Caption := inttostr(Trackbar3.Position);
 if chan <> 0 then
 BassVideo.BassVideo_SetPitchValue(chan, Trackbar3.Position)
end;

procedure TForm1.CheckBox2Click(Sender: TObject);
begin
 if chan <> 0 then
  begin
    BassVideo.BassVideo_SetPitchEnable(chan, checkbox2.Checked);
    TrackBar3Change(nil);
  end;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
 trackbar3.Position := 1000;
end;

procedure DataProc(chan : DWORD; NewDatasize : DWORD; user : Pointer); stdcall;
var buf : Pointer;
    size : DWORD;
begin
 if NewDatasize = 0 then exit;
 buf := allocmem(NewDataSize);
 size := Bass_ChannelGetData(chan, buf, NewDataSize);
 if size <> DWORD(-1) then
  writewav(buf, size);
 freemem(buf);
end;

procedure TForm1.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
 Form1.Cursor := crDefault;
 Timer_Hide_Mouse.Enabled := FALSE;
 if not isFullScreen then exit;
 Timer_Hide_Mouse.Enabled := TRUE;
end;

procedure TForm1.Timer_Hide_MouseTimer(Sender: TObject);
begin
 Form1.Cursor := crNone;
 Timer_Hide_Mouse.Enabled := FALSE;
end;

procedure TForm1.OpenFile1Click(Sender: TObject);
var h, w: integer;
    flags : DWORD;
begin
 if not OpenDialog1.Execute then exit;
 isEncoder := FALSE;
 Form3.Memo1.Clear;
 if chan <> 0 then
  begin
    BassVideo_Stop(chan);
    BassVideo_StreamFree(chan);
  end;
 isURL := FALSE;
 if checkbox4.Checked then
  flags := BASSVIDEO_VIDEOEFFECT
 else
  flags := 0;
 if Form1.CheckBox3.Checked then
  chan := BassVideo_StreamCreateFile(PChar(Form1.OpenDialog1.FileName), flags, Bass_Sample_Float, @myVideoProc, nil)
 else
  chan := BassVideo_StreamCreateFile(PChar(Form1.OpenDialog1.FileName), flags, 0, @myVideoProc, nil);
 VEffect := FALSE;
 if chan <> 0 then
  begin
   if checkbox4.Checked then
    Timer_Show_Text.Enabled := TRUE;
   ActiveSomeStuff;
   BassVideo_Play(chan);
   source := OpenDialog1.FileName;
   BassVideo_GetVideoInfo(chan, h, w);
   if (h > 0) and (w > 0) then
    begin
      Height := h + Panel1.Height + StatusBar1.Height;
      Width := w;
    end;
  end
 else source := '';
end;

procedure TForm1.OpenFilewithDualScreen1Click(Sender: TObject);
var h, w : integer;
   r : TRect;
begin
 if not OpenDialog1.Execute then exit;
 isEncoder := FALSE;
 if chan <> 0 then
  begin
    BassVideo_Stop(chan);
    BassVideo_StreamFree(chan);
  end;
 isURL := FALSE;
 if CheckBox3.Checked then
  chan := BassVideo_StreamCreateFile(PChar(OpenDialog1.FileName), 0, Bass_Sample_Float, @myVideoProc, nil)
 else
  chan := BassVideo_StreamCreateFile(PChar(OpenDialog1.FileName), 0, 0, @myVideoProc, nil);
 if chan <> 0 then
  begin
   // before play we add the new video window
   Form2.Show;
   R := Form2.ClientRect;
   BassVideo_AddVideo(chan, Form2.Handle, R, BassVideo_Auto_Resize or BassVideo_Auto_Move);
   ActiveSomeStuff;
   BassVideo_Play(chan);
   source := OpenDialog1.FileName;
   BassVideo_GetVideoInfo(chan, h, w);
   if (h <> 0) and (w <> 0) then
    begin
      Height := h + Panel1.Height + StatusBar1.Height;
      Width := w;
    end;
  end
 else source := '';
end;

procedure TForm1.ExtractAudio1Click(Sender: TObject);
begin
 if not OpenDialog1.Execute then exit;
 isEncoder := TRUE;
 if chan <> 0 then
  begin
    BassVideo_Stop(chan);
    BassVideo_StreamFree(chan);
  end;
 isURL := FALSE;
 chan := BassVideo.BassVideo_StreamCreateFile(PChar(opendialog1.FileName), 0, 0, @myVideoProc, nil);
 chan := BassVideo.BassVideo_EncoderAudio(chan, FALSE, @DataProc, nil);
 if chan = 0 then
  begin
    Form3.Memo1.Lines.Add('Cannot open file ' + opendialog1.FileName);
    exit;
  end;
 CreateWav('C:\BassVideo.wav');
 ActiveSomeStuff;
 BassVideo_Play(chan);
end;

procedure TForm1.Timer_Show_TextTimer(Sender: TObject);
begin
 if Timer_Buffering.Enabled then exit;
 if chan = 0 then exit;
 if VEffect then
  BassVideo_Effect_Remove(chan, hText)
 else
  hText := BassVideo_Effect_AddText(chan, 'BassVideo Demo', 10, 10, 'Arial', 24, 0, RGB(255, 255, 255), 0100); // bold
 VEffect := not VEffect;
end;

procedure TForm1.OpenDVD1Click(Sender: TObject);
var flags : DWORD;
begin
 if chan <> 0 then
  begin
    BassVideo_Stop(chan);
    BassVideo_StreamFree(chan);
  end;
 isURL := FALSE;
 if checkbox4.Checked then
  flags := BASSVIDEO_VIDEOEFFECT
 else
  flags := 0;
 VEffect := FALSE;
 if CheckBox3.Checked then
  chan := BassVideo_DVD_StreamCreate(nil, flags, Bass_Sample_Float, @myVideoProc, nil)
 else
  chan := BassVideo_DVD_StreamCreate(nil, flags, 0, @myVideoProc,nil);
 if chan = 0 then exit;
 BassVideo_Effect_AddText(chan, 'BassVideo Demo', 10, 10, 'Arial', 36, 0, RGB(255, 255, 255), 0);
 BassVideo_Effect_AddText(chan, 'Copyright(C) 2007-2008 by Kenshin1101', 10, 50, 'Arial', 16, 0, RGB(255, 255, 255), 0);
 ActiveSomeStuff;
 BassVideo_Play(chan);
end;

procedure TForm1.OpenDVDFiles1Click(Sender: TObject);
var flags : DWORD;
    s : widestring;
begin
 if not OpenDialog2.Execute then exit;
 s := OpenDialog2.FileName;
 if chan <> 0 then
  begin
    BassVideo_Stop(chan);
    BassVideo_StreamFree(chan);
  end;
 isURL := FALSE;
 if checkbox4.Checked then
  flags := BASSVIDEO_VIDEOEFFECT
 else
  flags := 0;
 VEffect := FALSE;
 if CheckBox3.Checked then
  chan := BassVideo_DVD_StreamCreate(PWideChar(s), flags, Bass_Sample_Float, @myVideoProc, nil)
 else
  chan := BassVideo_DVD_StreamCreate(PWideChar(s), flags, 0, @myVideoProc,nil);
 if chan = 0 then exit;
 BassVideo_Effect_AddText(chan, 'BassVideo Demo', 10, 10, 'Arial', 36, 0, RGB(255, 255, 255), 0);
 BassVideo_Effect_AddText(chan, 'Copyright(C) 2007-2008 by Kenshin1101', 10, 50, 'Arial', 16, 0, RGB(255, 255, 255), 0);
 ActiveSomeStuff;
 BassVideo_Play(chan);
end;

procedure TForm1.OpenCaptureDevice1Click(Sender: TObject);
begin
 if chan <> 0 then
  begin
    BassVideo_Stop(chan);
    BassVideo_StreamFree(chan);
  end;
 isURL := FALSE;
 Form4.ShowModal;
end;

procedure TForm1.ConvertVideo1Click(Sender: TObject);
begin
 Form5.ShowModal;
end;

function ThreadOpen(p: Pointer): integer;
begin
 BassVideo_SetConfig(BassVideo_Config_Audio_Renderer, 1);
 if Form1.CheckBox4.Checked then
 chan := BassVideo_StreamCreateURL(PChar(Form6.Edit1.Text), BASSVIDEO_VIDEOEFFECT, 0, @myVideoProc, nil)
 else
 chan := BassVideo_StreamCreateURL(PChar(Form6.Edit1.Text), 0, 0, @myVideoProc, nil);
 BassVideo_SetConfig(BassVideo_Config_Audio_Renderer, 0);
 BassVideo_Effect_AddText(chan, 'BassVideo Demo', 10, 10, 'Arial', 24, 0, RGB(255, 255, 255), 0100); // bold
 PostMessage(Form1.Handle, WM_USER + 1, 0, 0);
 result := 0;
end;

procedure TForm1.OpenURL1Click(Sender: TObject);
var id : DWORD;
begin
 Form6.ShowModal;
 if Form6.Edit1.Text = '' then exit;
 if chan <> 0 then
  begin
    BassVideo_Stop(chan);
    BassVideo_StreamFree(chan);
  end;
 chan := 0;
 isURL := TRUE;
 hThread := CreateThread(nil, 0, @ThreadOpen, nil, 0, id);
// if h = 0 then <- should not happen :)
end;

procedure TForm1.Timer_BufferingTimer(Sender: TObject);
var tg : integer;
begin
 tg := BassVideo_GetCurrentBuffering(chan);
 if tg = 0 then exit;
 Form1.StatusBar1.Panels[1].Text := 'Buffering... ' + inttostr(tg) + ' %';
 if tg = 100 then
  begin
   Timer_Buffering.Enabled := FALSE;
   Form1.StatusBar1.Panels[1].Text := '';
  end;
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
begin
 BassVideo_SetConfig(BassVideo_Config_Renderer, Combobox1.ItemIndex);
end;

end.
