unit Unit4;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm4 = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    ComboBox1: TComboBox;
    ComboBox2: TComboBox;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    procedure Button6Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure ComboBox2Change(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form4: TForm4;
implementation

uses BassVideo, Unit1;

{$R *.dfm}
var Enumcap : BOOL = FALSE;
    hCap : integer;

procedure TForm4.Button6Click(Sender: TObject);
begin
 if hCap <> 0 then
  BassVideo_StreamFree(hCap);
 close;
end;

function CB(Filter : HFilter; FilterName, FilterGuid : PChar; user : Pointer) : BOOL; stdcall;
begin
  TCombobox(user).Items.Add(FilterName);
  result := TRUE;
end;
procedure TForm4.FormShow(Sender: TObject);
begin
 if EnumCap then exit;
 EnumCap := TRUE;
 BassVideo_Capture_EnumDevice(Device_Video_Capture, @cb, Combobox1);
 BassVideo_Capture_EnumDevice(Device_Audio_Capture, @cb, Combobox2);
end;

procedure TForm4.Button5Click(Sender: TObject);
begin
 if hCap = 0 then exit;
 chan := BassVideo_Capture_Start(hCap, 0, 0, @myVideoProc, nil);
 if chan = 0 then exit;
  BassVideo_Play(chan);
 Form1.ActiveSomeStuff;
 close;
end;

procedure TForm4.ComboBox2Change(Sender: TObject);
var s1, s2 : PChar;
begin
 s1 := nil;
 if combobox1.ItemIndex <> -1 then
  s1 := PChar(Combobox1.Items[Combobox1.ItemIndex]);
 s2 := nil;
 if combobox2.ItemIndex <> -1 then
  s2 := PChar(Combobox2.Items[Combobox2.ItemIndex]);
 if hCap <> 0 then
  BassVideo_StreamFree(hCap);
 hCap := BassVideo_Capture_StreamCreate(s1, s2, TRUE);
end;

procedure TForm4.Button1Click(Sender: TObject);
begin
 if hCap <> 0 then
  BassVideo_Capture_ConfigDevice(hCap, Device_Video_Capture, Handle);
end;

procedure TForm4.Button3Click(Sender: TObject);
begin
 if hCap <> 0 then
  BassVideo_Capture_ConfigDevice(hCap, Device_Audio_Capture, Handle);

end;

procedure TForm4.Button2Click(Sender: TObject);
begin
 if hCap <> 0 then
  BassVideo_Capture_ConfigDevicePin(hCap, Device_Video_Capture, Handle);

end;

procedure TForm4.Button4Click(Sender: TObject);
begin
 if hCap <> 0 then
  BassVideo_Capture_ConfigDevicePin(hCap, Device_Audio_Capture, Handle);

end;

end.
