unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls;

type
  TForm1 = class(TForm)
    OpenDialog1: TOpenDialog;
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    Panel4: TPanel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    isFullScreen : Boolean;
    OldRect : TRect;
    OldStyle : Longint;
  end;

var
  Form1: TForm1;

implementation

uses Bass, BassVideo;

{$R *.dfm}
var chan1, chan2, chan3, chan4 : DWORD;

function myVideoProc(Handle : DWORD; Action, param1, param2 : DWORD; user : Pointer): BOOL; stdcall;
var R : TRect;
begin
 case Action of
  BassVideo_FoundVideo :
    begin
      if chan1 = 0 then
       begin
        R := Form1.Panel1.ClientRect;
        R.Left := 0;
        R.Top := 0;
        BASSVideo_SetVideoWindow(Handle, Form1.Panel1.Handle, R, 0);
      end
     else
      if chan2 = 0 then
       begin
        R := Form1.Panel2.ClientRect;
        R.Left := 0;
        R.Top := 0;
        BASSVideo_SetVideoWindow(Handle, Form1.Panel2.Handle, R, 0);
      end
     else
      if chan3 = 0 then
       begin
        R := Form1.Panel3.ClientRect;
        R.Left := 0;
        R.Top := 0;
        BASSVideo_SetVideoWindow(Handle, Form1.Panel3.Handle, R, 0);
      end
     else
      if chan4 = 0 then
       begin
        R := Form1.Panel4.ClientRect;
        R.Left := 0;
        R.Top := 0;
        BASSVideo_SetVideoWindow(Handle, Form1.Panel4.Handle, R, 0);
      end;
    end;
 end;
 result := FALSE;
end;

procedure TForm1.FormCreate(Sender: TObject);
var s : array[0..3] of string;
    i, c : integer;
begin
 Bass_Init(-1, 44100, 0, 0, nil);
 BassVideo_Init();
 if OpenDialog1.Execute then
  begin
    c := 4;
    if OpenDialog1.Files.Count < 4 then c := OpenDialog1.Files.Count;
    for i := 0 to c - 1 do s[i] := OpenDialog1.Files[i];


    chan1 := BassVideo_StreamCreateFile(PChar(s[0]), 0, 0, @myVideoProc, nil);
    if chan1 = 0 then Application.Terminate;

    if c > 1 then
    chan2 := BassVideo_AddFile(chan1, PChar(s[1]), 0, 0, @myVideoProc, nil);

    if c > 2 then
    chan3 := BassVideo_AddFile(chan1, PChar(s[2]), 0, 0, @myVideoProc, nil);

    if c > 3 then
    chan4 := BassVideo_AddFile(chan1, PChar(s[3]), 0, 0, @myVideoProc, nil);

    BassVideo_Play(chan1);
  end
 else Application.Terminate;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
 BassVideo_Free();
 Bass_Free;
end;

end.
