
#Region " Compiler Options "

Option Strict On
Option Explicit On
Option Compare Binary

#End Region

#Region " Library Imports "

Imports System.Windows.Forms

#End Region

' Template version 1.2.0.0. Code developed for framework v2.0.50727.1433
' This code is copyright (c) 2008 . All rights reserved.

'Namespace BassVideoNet

''' <summary>
''' File Open/Save dialogs
''' </summary>
''' <remarks>
''' -- Change Log --------------------------------------------------------
''' 2/8/2008 7:47:31 PM by Rick - Initial Creation
''' 
''' </remarks>
Public Class Dialogs

#Region " Public "

#Region " Public Shared Methods "

    Public Shared Function ShowOpenDialog(ByVal initialPath As String, ByVal filter As String, ByVal filterIndex As Integer, ByVal frm As Form) As String
        Dim DR As DialogResult = DialogResult.Retry
        Dim ofd1 As New OpenFileDialog ' System.Windows.Forms.OpenFileDialog
        Dim RetVal As String = ""

        ofd1.Filter = filter
        ofd1.FilterIndex = filterIndex
        ofd1.InitialDirectory = initialPath
        ofd1.Multiselect = False

        DR = ofd1.ShowDialog(frm)
        If DR = DialogResult.OK Then
            RetVal = ofd1.FileName
        End If
        ofd1.Dispose()
        ofd1 = Nothing

        Return RetVal
    End Function

    Public Shared Function ShowOpenDialogMultipleFiles(ByVal initialPath As String, ByVal filter As String, ByVal filterIndex As Integer, ByVal frm As Form) As String()
        Dim DR As DialogResult = DialogResult.Retry
        Dim ofd1 As New System.Windows.Forms.OpenFileDialog ' System.Windows.Forms.OpenFileDialog
        Dim RetVal As String() = Nothing

        ofd1.Filter = filter
        ofd1.FilterIndex = filterIndex
        ofd1.InitialDirectory = initialPath
        ofd1.Multiselect = True

        DR = ofd1.ShowDialog(frm)
        If DR = DialogResult.OK Then
            RetVal = ofd1.FileNames
        End If
        ofd1.Dispose()
        ofd1 = Nothing

        Return RetVal
    End Function

    Public Shared Function ShowSaveDialog(ByVal initialPath As String, ByVal filter As String, ByVal filterIndex As Integer, ByVal frm As Form) As String
        Dim DR As DialogResult = DialogResult.Retry
        Dim ofd1 As New SaveFileDialog ' System.Windows.Forms.SaveFileDialog
        Dim RetVal As String = ""

        ofd1.Filter = filter
        ofd1.FilterIndex = filterIndex
        ofd1.InitialDirectory = initialPath

        DR = ofd1.ShowDialog(frm)
        If DR = DialogResult.OK Then
            RetVal = ofd1.FileName
        End If
        ofd1.Dispose()
        ofd1 = Nothing

        Return RetVal
    End Function

    Public Shared Function ShowFolderDialog(ByVal initialPath As String, ByVal rootFolder As System.Environment.SpecialFolder, ByVal showNewFolderButton As Boolean, ByVal description As String, ByVal frm As Form) As String
        Dim FBD1 As New FolderBrowserDialog ' FolderBrowserDialog
        Dim DR As DialogResult
        Dim RetVal As String = ""

        FBD1.RootFolder = rootFolder
        FBD1.ShowNewFolderButton = showNewFolderButton
        FBD1.SelectedPath = initialPath
        FBD1.Description = description

        DR = FBD1.ShowDialog(frm)
        If DR = DialogResult.OK Then
            RetVal = FBD1.SelectedPath
        End If
        FBD1.Dispose()
        FBD1 = Nothing

        Return RetVal

    End Function
#End Region

#End Region

End Class

'End Namespace

