
#Region " Compiler Options "

Option Strict On
Option Explicit On
Option Compare Binary

#End Region

#Region " Library Imports "

#End Region

' Template version 1.2.0.0. Code developed for framework v2.0.50727.1433
' This code is copyright (c) 2008 . All rights reserved.

''' <summary>
''' Enter_Description_Here
''' </summary>
''' <remarks>
''' -- Change Log --------------------------------------------------------
''' 2/8/2008 7:18:40 PM by Rick - Initial Creation
''' 
''' </remarks>
Public Class VideoWindow

#Region " Form Events "

#Region " Private Form Declarations "

    Private _HasShown As Boolean = False
    Private _MoveToSecondaryDisplay As Boolean = True
    Private _SetupFonts As Boolean = True

#End Region

    Private Sub Form_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing

    End Sub

    Private Sub Form_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        If _SetupFonts Then SetupFontsForOs(Me)
        SetupScreenCentering(Me, _MoveToSecondaryDisplay)
    End Sub

    Private Sub Form_Resize(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Resize

    End Sub

    Private Sub Form_Shown(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Shown
        If Not _HasShown Then
            _HasShown = True
            Application.DoEvents()
            ' Do Something here
        End If
    End Sub

#Region " Custom Form Properties "

    ''' <summary>
    ''' Determines if the application is running on the Microsoft Windows Vista ? Operating System
    ''' </summary>
    ''' <value></value>
    ''' <returns>Boolean</returns>
    ''' <remarks></remarks>
    Public Shared ReadOnly Property IsVista() As Boolean
        Get
            Return Environment.OSVersion.Platform = PlatformID.Win32NT And Environment.OSVersion.Version.Major >= 6
        End Get
    End Property ' IsVista

#End Region

#Region " Custom Form Methods "

    ''' <summary>
    ''' Since the Segoe UI font doesn't exist in Windows XP ?, we set it to Trebuchet MS instead if not Windows Vista
    ''' </summary>
    ''' <param name="frm">The form to modify</param>
    ''' <remarks></remarks>
    Private Sub SetupFontsForOs(ByVal frm As System.Windows.Forms.Form)
        frm.SuspendLayout()
        If IsVista Then
            frm.Font = New System.Drawing.Font("Segoe UI", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Else
            frm.Font = New System.Drawing.Font("Trebuchet MS", 9.75!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        End If
        frm.ResumeLayout(False)
    End Sub ' SetupFontsForOs

    ''' <summary>
    ''' Centers a form on either a primary or seconday display
    ''' </summary>
    ''' <param name="frm">The form to center</param>
    ''' <param name="moveToSecondarydisplay">Determines if the form gets centered on the primary display or secondary</param>
    ''' <remarks></remarks>
    Private Sub SetupScreenCentering(ByRef frm As System.Windows.Forms.Form, ByVal moveToSecondarydisplay As Boolean)
        Dim SelScreen As System.Windows.Forms.Screen = Nothing
        If moveToSecondarydisplay Then
            If Screen.AllScreens.Length > 1 Then
                SelScreen = Screen.AllScreens(1)
            Else
                SelScreen = Screen.PrimaryScreen
            End If
        Else
            SelScreen = Screen.PrimaryScreen
        End If
        frm.Top = SelScreen.Bounds.Top + CType(((SelScreen.WorkingArea.Height / 2) - (frm.Height / 2)), Integer)
        frm.Left = SelScreen.Bounds.Left + CType(((SelScreen.WorkingArea.Width / 2) - (frm.Width / 2)), Integer)
    End Sub ' SetupScreenCentering

#End Region

#End Region

#Region " Private "

#Region " Private Variable Declarations "

#End Region

#Region " Private Methods "

#End Region

#Region " Private Shared Methods "

#End Region

#End Region

#Region " Public "

#Region " Public Property Declarations "

#End Region

#Region " Public Shared Property Declarations "

#End Region

#Region " Public Enumerations "

#End Region

#Region " Public Delegates "

#End Region

#Region " Public Callbacks "

#End Region

#Region " Public Events "

#End Region

#Region " Public Methods "

#End Region

#Region " Public Shared Methods "

#End Region

#End Region

End Class
