Attribute VB_Name = "mdBassVideo"
' BassVideo Module for VB
' Copyright(C) 2008 by Nguyen Nhat Dung
' Special thanks to SoundMike, xtremex_x

Option Explicit

Public Const BassVideo_Config_Renderer = &H100           ' for BassVideo_SetConfig
Public Const BassVideo_Congfig_WMASF_READER = &H101

Public Const WM_VIDEO_8 = 100
Public Const WM_VIDEO_9 = 101
Public Const WM_AUTO_SELECT = -1         ' for ASFConfig AudioCodec value

Public Const Video_WMV = 1
Public Const Video_AVI = 0
Public Const EncoderType_Video = 0
Public Const EncoderType_Audio = 1
Public Const EncoderType_WMASF = 2
Public Const Device_Video_Capture = 3
Public Const Device_Audio_Capture = 4

    ' effect
Public Const EFFECT_POSITION_X = 1
Public Const EFFECT_POSITION_Y = 2
Public Const EFFECT_TEXT = 3
Public Const EFFECT_TEXT_COLOR = 4
Public Const EFFECT_FONT = 5
Public Const EFFECT_PICTURE_HANDLE = 6
Public Const EFFECT_PICTURE_ALPHA = 7
Public Const EFFECT_PICTURE_TRANSPARENT = 8
    ' vmr 9 effect
Public Const BASSVIDEO_VMR9_ZORDER = 1
Public Const BASSVIDEO_VMR9_ALPHA = 2
Public Const BASSVIDEO_VMR9_BGRCOLOR = 3

Public Const WM_PROFILE = 0
Public Const WM_DONT_COMPRESS = 1       ' 0 = false , 1 = true
Public Const WM_MULTI_PASS = 2          ' 0 = false , 1 = true
Public Const WM_AUTOINDEX = 3
Public Const wmp_V80_255VideoPDA = 0
Public Const wmp_V80_150VideoPDA = 1
Public Const wmp_V80_28856VideoMBR = 2
Public Const wmp_V80_100768VideoMBR = 3
Public Const wmp_V80_288100VideoMBR = 4
Public Const wmp_V80_288Video = 5
Public Const wmp_V80_56Video = 6
Public Const wmp_V80_100Video = 7
Public Const wmp_V80_256Video = 8
Public Const wmp_V80_384Video = 9
Public Const wmp_V80_768Video = 10
Public Const wmp_V80_700NTSCVideo = 11
Public Const wmp_V80_1400NTSCVideo = 12
Public Const wmp_V80_384PALVideo = 13
Public Const wmp_V80_700PALVideo = 14
Public Const wmp_V80_288MonoAudio = 15
Public Const wmp_V80_288StereoAudio = 16
Public Const wmp_V80_32StereoAudio = 17
Public Const wmp_V80_48StereoAudio = 18
Public Const wmp_V80_64StereoAudio = 19
Public Const wmp_V80_96StereoAudio = 20
Public Const wmp_V80_128StereoAudio = 21
Public Const wmp_V80_288VideoOnly = 22
Public Const wmp_V80_56VideoOnly = 23
Public Const wmp_V80_FAIRVBRVideo = 24
Public Const wmp_V80_HIGHVBRVideo = 25
Public Const wmp_V80_BESTVBRVideo = 26

' 2.4.1.0 new type added
Public Type BassVideoFrameInfo
 AvgFrameRate As Long
 FrameDraw As Long
 FrameDrop As Long
End Type

Public Type TMsg
 Msg As Long
 param1 As Long
 param2 As Long
End Type

Public Type BassVideoInfo
 AvgTimePerFrame As Double
 Height As Long
 Width As Long
 FormatType As Long
 VideoFormat As Long
 VideoFormat_GUID As Long
End Type

Public Type WMAudioFormat
 Bitrate As Long
 freq As Long
 nChan As Long
 wBitPerSample As Long
End Type

Public Type ASFConfig
  version As Long
  Has_Audio As Long
  Has_Video As Long
  VideoBitrate As Long
  useVideoVBR As Long
  VBRQuality As Long
  VideoCodec As Long
  SrcVideoFrameHeight As Long
  SrcVideoFrameWidth As Long
  DestVideoFrameHeight As Long
  DestVideoFrameWidth As Long
  VideoQuality As Long
  AudioCodec As Long
  AudioCodecFormat As Long
  AudioBitrate As Long
  Audio_Frequency As Long
  Audio_Channel As Long
  Audio_Bits_Per_Sample As Long
End Type
Public Const VIDEOTYPE_UNKNOW = 0
'Uncompressed RGB Video Subtypes
Public Const VIDEOTYPE_RGB1 = 1
Public Const VIDEOTYPE_RGB4 = 2
Public Const VIDEOTYPE_RGB8 = 3
Public Const VIDEOTYPE_RGB555 = 4
Public Const VIDEOTYPE_RGB565 = 5
Public Const VIDEOTYPE_RGB24 = 6
Public Const VIDEOTYPE_RGB32 = 7
Public Const VIDEOTYPE_ARGB1555 = 8
Public Const VIDEOTYPE_ARGB32 = 9
Public Const VIDEOTYPE_ARGB4444 = 10
Public Const VIDEOTYPE_A2R10G10B10 = 11
Public Const VIDEOTYPE_A2B10G10R10 = 12
'YUV
Public Const VIDEOTYPE_AYUV = 13
Public Const VIDEOTYPE_YUY2 = 14
Public Const VIDEOTYPE_UYVY = 15
Public Const VIDEOTYPE_IMC1 = 16
Public Const VIDEOTYPE_IMC3 = 17
Public Const VIDEOTYPE_IMC2 = 18
Public Const VIDEOTYPE_IMC4 = 19
Public Const VIDEOTYPE_YV12 = 20
Public Const VIDEOTYPE_NV12 = 21
Public Const VIDEOTYPE_Y411 = 22
Public Const VIDEOTYPE_Y41P = 23
Public Const VIDEOTYPE_Y211 = 24
Public Const VIDEOTYPE_YVYU = 25
Public Const VIDEOTYPE_YVU9 = 26
Public Const VIDEOTYPE_IF09 = 27
'Analog Video Subtypes
Public Const VIDEOTYPE_AnalogVideo_NTSC_M = 28
Public Const VIDEOTYPE_AnalogVideo_PAL_B = 29
Public Const VIDEOTYPE_AnalogVideo_PAL_D = 30
Public Const VIDEOTYPE_AnalogVideo_PAL_G = 31
Public Const VIDEOTYPE_AnalogVideo_PAL_H = 32
Public Const VIDEOTYPE_AnalogVideo_PAL_I = 33
Public Const VIDEOTYPE_AnalogVideo_PAL_M = 34
Public Const VIDEOTYPE_AnalogVideo_PAL_N = 35
Public Const VIDEOTYPE_AnalogVideo_SECAM_B = 36
Public Const VIDEOTYPE_AnalogVideo_SECAM_D = 37
Public Const VIDEOTYPE_AnalogVideo_SECAM_G = 38
Public Const VIDEOTYPE_AnalogVideo_SECAM_H = 39
Public Const VIDEOTYPE_AnalogVideo_SECAM_K = 40
Public Const VIDEOTYPE_AnalogVideo_SECAM_K1 = 41
Public Const VIDEOTYPE_AnalogVideo_SECAM_L = 42
'DirectX Video Acceleration Video Subtypes
Public Const VIDEOTYPE_AI44 = 43
Public Const VIDEOTYPE_IA44 = 44
'DV Video Subtypes
Public Const VIDEOTYPE_dvsl = 45
Public Const VIDEOTYPE_dvsd = 46
Public Const VIDEOTYPE_dvhd = 47
'Professional Formats
Public Const VIDEOTYPE_dv25 = 48
Public Const VIDEOTYPE_dv50 = 49
Public Const VIDEOTYPE_dvh1 = 50
Public Const VIDEOTYPE_DVCS = 51
'Video Mixing Renderer Video Subtypes
'VMR-7 Subtypes
Public Const VIDEOTYPE_RGB32_D3D_DX7_RT = 52
Public Const VIDEOTYPE_RGB16_D3D_DX7_RT = 53
Public Const VIDEOTYPE_ARGB32_D3D_DX7_RT = 54
Public Const VIDEOTYPE_ARGB4444_D3D_DX7_RT = 55
Public Const VIDEOTYPE_ARGB1555_D3D_DX7_RT = 56
'VMR-9 Subtypes
Public Const VIDEOTYPE_RGB32_D3D_DX9_RT = 57
Public Const VIDEOTYPE_RGB16_D3D_DX9_RT = 58
Public Const VIDEOTYPE_ARGB32_D3D_DX9_RT = 59
Public Const VIDEOTYPE_ARGB4444_D3D_DX9_RT = 60
Public Const VIDEOTYPE_ARGB1555_D3D_DX9_RT = 61
'Miscellaneous Video Subtypes
Public Const VIDEOTYPE_CFCC = 62
Public Const VIDEOTYPE_CLJR = 63
Public Const VIDEOTYPE_CPLA = 64
Public Const VIDEOTYPE_CLPL = 65
Public Const VIDEOTYPE_IJPG = 66
Public Const VIDEOTYPE_MDVF = 67
Public Const VIDEOTYPE_MJPG = 68
Public Const VIDEOTYPE_MPEG1Packet = 69
Public Const VIDEOTYPE_MPEG1Payload = 70
Public Const VIDEOTYPE_Overlay = 71
Public Const VIDEOTYPE_Plum = 72
Public Const VIDEOTYPE_QTJpeg = 73
Public Const VIDEOTYPE_QTMovie = 74
Public Const VIDEOTYPE_QTRle = 75
Public Const VIDEOTYPE_QTRpza = 76
Public Const VIDEOTYPE_QTSmc = 77
Public Const VIDEOTYPE_TVMJ = 78
Public Const VIDEOTYPE_VPVBI = 79
Public Const VIDEOTYPE_VPVideo = 80
Public Const VIDEOTYPE_WAKE = 81
' end of 2.4.1.0 type added

' video display
Public Type Rect
    Left As Long
    top As Long
    Right As Long
    Bottom As Long
End Type

' video render option
Public Enum BassVideo_RenderOpt
    Default = 0
    VMR9 = 1
    VMR9_Windowless = 2
    EVR = 3
    Overlay = 4
    NOVIdeo = 5
End Enum

' action
Public Enum BassVideo_Action
    BassVideo_OpenDone = 1     ' Handle as Long = 0 if failed , <> 0 if success
    BassVideo_Buffering = 2    ' param1 : 0 if buffering done, <> 0 if buffering in progress , param2 = buffer %
    BassVideo_FoundVideo = 3   ' Handle as Long tell the app must prepare the video windows & Handle
    BassVideo_EndStream = 4    ' End Stream
    BassVideo_DShow_Event = 5  ' DShow event
    BassVideo_WM_Move = 6
    BassVideo_WM_Size = 7
    BassVideo_WM_Paint = 8
    BassVideo_WM_Mouse_Click = 9
    BassVideo_WM_Mouse_Move = 10
    BassVideo_PlayEvent = 11
End Enum

Public Const BassVideo_Is_Play = 1
Public Const BassVideo_Is_Pause = 2
Public Const BassVideo_Is_Stop = 3

'flags
Public Enum BassVideo_Flags
    BASSVIDEO_MULTIVIDEO = 1
    BASSVIDEO_AUTO_PAINT = 2
    BASSVIDEO_AUTO_RESIZE = 4
    BASSVIDEO_AUTO_MOVE = 8
    BASSVIDEO_FILTERNAME = 16
    BASSVIDEO_UNICODE = 32
    BASSVIDEO_VIDEOEFFECT = 64
    BASSVIDEO_DISABLE_VIDEO = 128
End Enum


Public Const BASSVIDEO_MEDIA_UNKNOWN = 0
Public Const BASSVIDEO_MEDIA_AVI = 2

'color set
Public Enum BassVideo_Color
    COLOR_Brightness = 1
    COLOR_Contrast = 2
    COLOR_Hue = 3
    COLOR_Saturation = 4
End Enum

' error code
Public Enum BassVideo_Error
      ' error code
      BASSVIDEO_ERROR_UNKNOW = -1
      BASSVIDEO_ERROR_SUCCESS = 0
      BASSVIDEO_ERROR_INVALID_HANDLE = 1
      BASSVIDEO_ERROR_INVALID_COLOR_MODE = 2
      BASSVIDEO_ERROR_NULL_CALLBACK = 3
      BASSVIDEO_ERROR_DOESNT_HAVE_PROPERTY_PAGE = 4
      BASSVIDEO_ERROR_NULL_FILTER = 5
End Enum

Public Enum ResizeType
    R43
    R169
    RSource
    RFree
    RCustom
End Enum

Declare Sub BassVideo_SetConfig Lib "BassVideo.dll" ( _
    ByVal pOption As Long, _
    ByVal value As Long _
)

Declare Sub BassVideo_Free Lib "BassVideo.dll" ()

Declare Sub BassVideo_SetVideoWindow Lib "BassVideo.dll" ( _
    ByVal handle As Long, _
    ByVal VideoWindowHandle As Long, _
    ByRef VideoRect As Rect, _
    ByVal VideoNum As Long _
)

Declare Sub BassVideo_Repaint Lib "BassVideo.dll" ( _
   ByVal handle As Long, _
   ByVal WinHandle As Long, _
   ByVal DC As Long, _
   ByVal VideoNum As Long _
)

Declare Sub BassVideo_WindowResize Lib "BassVideo.dll" ( _
    ByVal handle As Long, _
    ByRef Rect As Rect, _
    ByVal VideoNum As Long _
)   ' MJD

Declare Sub BassVideo_WindowMove Lib "BassVideo.dll" ( _
    ByVal handle As Long, _
    ByVal Msg As Long, _
    ByVal wParam As Long, _
    ByVal lparam As Long, _
    ByVal VideoNum As Long _
)


Declare Function BassVideo_StreamCreateFileMem Lib "BassVideo.dll" ( _
    ByVal data As Any, _
    ByVal datalen As Long, _
    ByVal mediatype As Long, _
    ByVal flags As Long, _
    ByVal BassFlags As Long, _
    ByVal CallBackProc As Long, _
    ByVal user As Long _
) As Long

Declare Function BassVideo_StreamCreateFileUser Lib "BassVideo.dll" ( _
    ByVal UserProc As Any, _
    ByVal mediatype As Long, _
    ByVal flags As Long, _
    ByVal BassFlags As Long, _
    ByVal CallBackProc As Long, _
    ByVal user As Long _
) As Long


Declare Function BassVideo_StreamCreateFile Lib "BassVideo.dll" ( _
    ByVal filename As String, _
    ByVal flags As Long, _
    ByVal BassFlags As Long, _
    ByVal CallBackProc As Long, _
    ByVal user As Long _
) As Long

Declare Function BassVideo_Play Lib "BassVideo.dll" ( _
    ByVal handle As Long) As Long

Declare Function BassVideo_Stop Lib "BassVideo.dll" ( _
    ByVal handle As Long _
) As Long

Declare Function BassVideo_Pause Lib "BassVideo.dll" ( _
    ByVal handle As Long _
) As Long

Declare Function BassVideo_SetPosition Lib "BassVideo.dll" ( _
    ByVal handle As Long, _
    ByVal pos As Double _
) As Long

Declare Function BassVideo_SetEndPosition Lib "BassVideo.dll" ( _
    ByVal handle As Long, _
    ByVal pos As Double _
) As Long

Declare Function BassVideo_GetPosition Lib "BassVideo.dll" ( _
    ByVal handle As Long _
) As Double

Declare Function BassVideo_GetLength Lib "BassVideo.dll" ( _
    ByVal handle As Long _
) As Double

Declare Sub BassVideo_StreamFree Lib "BassVideo.dll" ( _
    ByVal handle As Long _
)

Declare Function BassVideo_Init Lib "BassVideo.dll" () As Long

Declare Function BassVideo_SetEventNotify Lib "BassVideo.dll" ( _
    ByVal handle As Long, _
    ByVal hwnd As Long, _
    ByVal lMsg As Long, _
    ByVal lInstanceData As Long _
) As Long

Declare Function BassVideo_GetEvent Lib "BassVideo.dll" ( _
    ByVal handle As Long, _
    ByRef lEventCode As Long, _
    ByRef lParam1 As Long, _
    ByRef lParam2 As Long, _
    ByVal msTimeoutas As Long _
) As Long

Declare Function BassVideo_SetRatio Lib "BassVideo.dll" ( _
    ByVal handle As Long, _
    ByVal value As Long, _
    ByVal custom As Double, _
    ByVal VideoNum As Long _
) As Long

Declare Function BassVideo_SetChannel Lib "BassVideo.dll" ( _
    ByVal chan As Long, _
    ByVal newChan As Long _
) As Long

Declare Function BassVideo_AddFile Lib "BassVideo.dll" ( _
    ByVal Oldchan As Long, _
    ByVal filename As Any, _
    ByVal flags As Long, _
    ByVal BassFlags As Long, _
    ByVal CallBackProc As Long, _
    ByVal user As Long _
) As Long

Declare Function BassVideo_GetVersion Lib "BassVideo.dll" () As Long

Declare Function BassVideo_EventToString Lib "BassVideo.dll" ( _
    ByVal lpEvent As Long _
) As String

Declare Function BassVideo_AddVideo Lib "BassVideo.dll" ( _
    ByVal chan As Long, _
    ByVal ParentHandle As Long, _
    ByRef Rect As Rect, _
    ByVal flags As Long) As Long

Declare Function BassVideo_AddVideo2 Lib "BassVideo.dll" ( _
    ByVal chan As Long, _
    ByVal ParentHandle As Long, _
    ByVal L As Long, _
    ByVal T As Long, _
    ByVal r As Long, _
    ByVal B As Long, _
    ByVal flags As Long) As Long
    
Declare Function BassVideo_GetGraph Lib "BassVideo.dll" ( _
    ByVal chan As Long _
) As Long

Declare Function BassVideo_FrameStep Lib "BassVideo.dll" ( _
    ByVal chan As Long _
) As Long

' START MJD
Declare Function BassVideo_SetColor Lib "BassVideo.dll" ( _
    ByVal chan As Long, _
    ByVal Color As Long, _
    ByVal value As Single, _
    ByVal VideoNum As Long, _
    ByVal flags As Long _
) As Long

Declare Function BassVideo_GetColorRange Lib "BassVideo.dll" ( _
    ByVal chan As Long, _
    ByVal Color As Long, _
    ByVal VideoNum As Long, _
    ByVal flags As Long, _
    ByRef CMax As Single, _
    ByRef CMin As Single, _
    ByRef CDef As Single _
) As Long
' END MJD


Declare Function BassVideo_CaptureBitmap Lib "BassVideo.dll" ( _
    ByVal lpSourceFile As Long, _
    ByVal CaptureTime As Double, _
    ByVal BitmapOutput As Long, _
    ByVal flags As Long) _
As Long

Declare Function BassVideo_EnumFilter Lib "BassVideo.dll" ( _
    ByVal chan As Long, _
    ByVal CallBack As Long, _
    ByVal user As Long) _
As Long

Declare Function BassVideo_HaveFilterPropertyPage Lib "BassVideo.dll" ( _
    ByVal chan As Long, _
    ByVal Filter As Long, _
    ByVal flags As Long) _
As Long

Declare Function BassVideo_ShowFilterPropertyPage Lib "BassVideo.dll" ( _
    ByVal chan As Long, _
    ByVal Filter As Long, _
    ByVal ParentHandle As Long, _
    ByVal flags As Long) _
As Long

Declare Function BassVideo_SaveGraphFile Lib "BassVideo.dll" ( _
    ByVal chan As Long, _
    ByVal filename As Long, _
    ByVal flags As Long) _
As Long

Declare Sub BassVideo_CloseWindow Lib "BassVideo.dll" ( _
    ByVal chan As Long, _
    ByVal VideoNum As Long)

Declare Function BassVideo_GetVideoWindow Lib "BassVideo.dll" ( _
    ByVal chan As Long, _
    ByVal VideoNum As Long) _
As Long

Declare Function BassVideo_SetTempoValue Lib "BassVideo.dll" ( _
    ByVal chan As Long, _
    ByVal value As Long) _
As Long

Declare Function BassVideo_SetTempoEnable Lib "BassVideo.dll" ( _
    ByVal chan As Long, _
    ByVal value As Long) _
As Long

Declare Function BassVideo_GetTempoValue Lib "BassVideo.dll" (ByVal chan As Long) As Long

Declare Function GetTempoEnable Lib "BassVideo.dll" (ByVal chan As Long) As Long

' new function in 2.4.1.0
Declare Function BassVideo_SetPitchValue Lib "BassVideo.dll" ( _
    ByVal chan As Long, _
    ByVal value As Long) _
As Long

Declare Function BassVideo_SetPitchEnable Lib "BassVideo.dll" ( _
    ByVal chan As Long, _
    ByVal value As Long) _
As Long

Declare Function BassVideo_GetPitchValue Lib "BassVideo.dll" (ByVal chan As Long) As Long

Declare Function GetPitchEnable Lib "BassVideo.dll" (ByVal chan As Long) As Long

Declare Function BassVideo_GetInfo Lib "BassVideo.dll" (ByVal chan As Long, ByRef info As BassVideoInfo) As Long

Declare Function BassVideo_GetFrameInfo Lib "BassVideo.dll" ( _
    ByVal chan As Long, _
    ByRef info As BassVideoFrameInfo) _
As Long

Declare Function BassVideo_EncoderAudio Lib "BassVideo.dll" (ByVal chan As Long, _
    ByVal VidPreview As Long, _
    ByVal DataProc As Long, _
    ByVal user As Long) _
As Long

Declare Function BassVideo_EnumEncoder Lib "BassVideo.dll" ( _
    ByVal EncoderType As Long, _
    ByVal CallBack As Long, _
    ByVal user As Long)

Declare Function BassVideo_ConfigEncoderFilter Lib "BassVideo.dll" ( _
    ByVal chan As Long, _
    ByVal EncoderType As Long, _
    ByVal ParentHandle As Long) _
As Long

Declare Function BassVideo_ConfigFilter Lib "BassVideo.dll" ( _
    ByVal FilterType As Long, _
    ByVal FilterName As String, _
    ByVal ParentHandle As Long) _
As Long

Declare Function BassVideo_CreateEncoder Lib "BassVideo.dll" (ByVal FilterGUID As Long) As Long

Declare Function BassVideo_EncoderVideo Lib "BassVideo.dll" ( _
    ByVal fin As String, _
    ByVal FOut As String, _
    ByVal VideoType As Long, _
    ByVal flags As Long, _
    ByVal VideoCodec As Long, _
    ByVal AudioCodec As Long, _
    ByVal VidProc As Long, _
    ByVal user As Long) _
As Long

Declare Function BassVideo_Effect_AddText Lib "BassVideo.dll" ( _
    ByVal chan As Long, _
    ByVal Text As String, _
    ByVal x As Long, _
    ByVal y As Long, _
    ByVal FontName As String, _
    ByVal FontHeight As Long, _
    ByVal FontWidth As Long, _
    ByVal Fontcolor As Long, _
    ByVal FontStyle As Long) _
As Long

Declare Function BassVideo_Effect_AddText2 Lib "BassVideo.dll" ( _
    ByVal chan As Long, _
    ByVal Text As String, _
    ByVal x As Long, _
    ByVal y As Long, _
    ByVal hfont As Long, _
    ByVal Fontcolor As Long) _
As Long

Declare Function BassVideo_Effect_Set_Draw_CallBack Lib "BassVideo.dll" ( _
    ByVal chan As Long, _
    ByVal CallBackFunction As Long, _
    ByVal user As Long) _
As Long

Declare Function BassVideo_Effect_Remove Lib "BassVideo.dll" ( _
    ByVal chan As Long, _
    ByVal hText As Long) _
As Long

Declare Function BassVideo_DVD_StreamCreate Lib "BassVideo.dll" ( _
    ByVal Dvdpath As String, _
    ByVal flags As Long, _
    ByVal BassFlags As Long, _
    ByVal VidProc As Long, _
    ByVal user As Long) _
As Long

Declare Function BassVideo_DVD_ShowMenu Lib "BassVideo.dll" (ByVal chan As Long) As Long
Declare Function BassVideo_DVD_MouseMove Lib "BassVideo.dll" (ByVal chan As Long, ByVal lparam As Long) As Long

Declare Function BassVideo_DVD_MouseClick Lib "BassVideo.dll" (ByVal chan As Long, ByVal lparam As Long) As Long

Declare Function BassVideo_DVD_EnableCaptions Lib "BassVideo.dll" (ByVal chan As Long, _
ByVal CaptionEnable As Long) As Long

Declare Function BassVideo_DVD_ShowTitle Lib "BassVideo.dll" (ByVal chan As Long) As Long

Declare Function BassVideo_DVD_SaveBookMarks Lib "BassVideo.dll" (ByVal chan As Long, _
ByVal filename As String, _
ByVal name As String) As Long

Declare Function BassVideo_DVD_RestoreBookMarks Lib "BassVideo.dll" ( _
ByVal chan As Long, _
ByVal filename As String, ByVal name As String) As Long
Declare Function BassVideo_DVD_GetTitleCount Lib "BassVideo.dll" (ByVal chan As Long) As Long
Declare Function BassVideo_DVD_GetChapterCount Lib "BassVideo.dll" (ByVal chan As Long, _
ByVal title As Long) As Long

Declare Function BassVideo_DVD_Play Lib "BassVideo.dll" ( _
ByVal chan As Long, _
ByVal title As Long, _
ByVal chapter As Long, time As Double) As Long

Declare Function BassVideo_DVD_SetPlayRate Lib "BassVideo.dll" ( _
ByVal chan As Long, ByVal Rate As Double) As Long

Declare Function BassVideo_DVD_PlayNextChapter Lib "BassVideo.dll" (ByVal chan As Long) As Long

Declare Function BassVideo_DVD_PlayPrevChapter Lib "BassVideo.dll" (ByVal chan As Long) As Long

Declare Function BassVideo_DVD_RePlayChapter Lib "BassVideo.dll" (ByVal chan As Long) As Long

Declare Function BassVideo_DVD_PlayTitleInTime Lib "BassVideo.dll" ( _
ByVal chan As Long, ByVal title As Long, ByVal from_time As Double, ByVal to_time As Double) As Long

Declare Function BassVideo_DVD_PlayChapterAndStop Lib "BassVideo.dll" ( _
ByVal chan As Long, ByVal title As Long, ByVal chapter As Long, ByVal num As Long) As Long

Declare Function BassVideo_DVD_GetAudioLanguageCount Lib "BassVideo.dll" ( _
ByVal chan As Long, ByRef LangCount As Long, ByRef CurrentLang As Long) As Long

Declare Function BassVideo_DVD_GetAudioLanguage Lib "BassVideo.dll" ( _
ByVal chan As Long, ByVal LangIndex As Long) As String

Declare Function BassVideo_DVD_SetAudioLanguage Lib "BassVideo.dll" ( _
ByVal chan As Long, ByVal LangIndex As Long) As Long

Declare Function BassVideo_DVD_GetSubtitleCount Lib "BassVideo.dll" ( _
ByVal chan As Long, ByRef MaxSub As Long, ByRef CurrentSub As Long, ByRef isSubShow As Long) As Long

Declare Function BassVideo_DVD_GetSubtitleName Lib "BassVideo.dll" ( _
ByVal chan As Long, ByVal LangIndex As Long) As String

Declare Function BassVideo_DVD_SetSubtitle Lib "BassVideo.dll" ( _
ByVal chan As Long, ByVal LangIndex As Long) As Long

Declare Function BassVideo_DVD_EnableSubtitle Lib "BassVideo.dll" ( _
ByVal chan As Long, ByVal Enable As Long) As Long

Declare Function BassVideo_DVD_SelectParentalLevel Lib "BassVideo.dll" ( _
ByVal chan As Long, ByVal Level As Long) As Long

Declare Function BassVideo_DVD_GetAngleCount Lib "BassVideo.dll" ( _
ByVal chan As Long, ByRef anglemax As Long, ByRef CurrentAngle As Long) As Long

Declare Function BassVideo_DVD_SetCurrentAngle Lib "BassVideo.dll" ( _
ByVal chan As Long, ByVal CurrentAngle As Long) As Long

Declare Function BassVideo_Capture_EnumDevice Lib "BassVideo.dll" ( _
ByVal DeviceType As Long, CallBack As Long, user As Long) As Long

Declare Function BassVideo_Capture_StreamCreate Lib "BassVideo.dll" ( _
ByVal Video_Device As Any, Audio_Device As Any, ByVal isFilterName As Long) As Long

Declare Function BassVideo_Capture_Start Lib "BassVideo.dll" ( _
ByVal handle As Long, ByVal flags As Long, ByVal BassFlags As Long, _
ByVal VidProc As Long, ByVal user As Long) As Long

Declare Function BassVideo_Capture_ConfigDevice Lib "BassVideo.dll" ( _
ByVal handle As Long, ByVal device As Long, ByVal parent As Long) As Long

Declare Function BassVideo_Capture_ConfigDevicePin Lib "BassVideo.dll" ( _
ByVal handle As Long, ByVal device As Long, ByVal parent As Long) As Long

Declare Function BassVideo_Encoder_Create Lib "BassVideo.dll" (ByVal chan As Long, _
ByVal FOut As String, _
ByVal OutputType As Long, ByVal EncoderSetting As Long) As Long


Declare Function BassVideo_Encoder_SetWMSetting Lib "BassVideo.dll" (ByVal chan As Long, _
ByVal setting As Long, ByVal value As Long) As Long

Declare Function BassVideo_Encoder_GetWMSettingCount Lib "BassVideo.dll" (ByVal SettingType As Long, _
ByRef CodecCount As Long, ByRef FormatCount As Long) As Long

Declare Function BassVideo_Encoder_GetWMSetting Lib "BassVideo.dll" (ByVal SettingType As Long, _
ByVal CodecCount As Long, ByVal FormatCount As Long, ByRef value As Any) As Long

Declare Function BassVideo_Effect_AddPicture Lib "BassVideo.dll" (ByVal chan As Long, _
ByVal pictureHandle As Long, ByVal x As Long, ByVal y As Long, ByVal alpha As Long, _
ByVal transparentcolor As Long) As Long

Declare Function BassVideo_Effect_SetInfo Lib "BassVideo.dll" (ByVal chan As Long, ByVal hEffect As Long, _
ByVal setting As Long, ByVal value As Any) As Long

Declare Function BassVideo_VMR9Effect_Create Lib "BassVideo.dll" (ByVal hwnd As Long) As Long

Declare Sub BassVideo_VMR9Effect_Free Lib "BassVideo.dll" (ByVal handle As Long)

Declare Function BassVideo_VMR9Effect_AddFile Lib "BassVideo.dll" (ByVal hEffect As Long, _
    ByVal filename As String, _
    ByVal flags As Long, _
    ByVal BassFlags As Long, _
    ByVal CallBackProc As Long, _
    ByVal user As Long) As Long


Declare Function BassVideo_VMR9Effect_Remove Lib "BassVideo.dll" (ByVal hEffect As Long, ByVal chan As Long) As Long

Declare Function BassVideo_VMR9Effect_SetInfo Lib "BassVideo.dll" (ByVal hEffect As Long, _
                           ByVal chan As Long, ByVal info As Long, ByVal value As Any) As Long

Declare Function BassVideo_VMR9Effect_AddURL Lib "BassVideo.dll" (ByVal hEffect As Long, _
    ByVal filename As String, _
    ByVal flags As Long, _
    ByVal BassFlags As Long, _
    ByVal CallBackProc As Long, _
    ByVal user As Long) As Long

Function VIDEOPROC(ByVal handle As Long, ByVal action As Long, _
              ByVal param1 As Long, ByVal param2 As Long, ByVal user As Long) As Long
              
End Function

Function FilterProc(ByVal handle As Long, ByVal FilterName As Long, ByVal Filter As Long, ByVal user As Long) As Long

End Function
Sub AudioEncoderCallBack(ByVal chan As Long, ByVal NewDataSize As Long, ByVal user As Long)

End Sub

Function CallBackEnumEncoderFilter(ByVal Filter As Long, ByVal FilterName As String, ByVal FilterGUID As String, ByVal user As Long) As Long
End Function

Sub CallBackDraw(ByVal chan As Long, ByVal DC As Long, ByVal user As Long)

End Sub

