// AudioReplace.cpp : Defines the entry point for the application.
//

#include "stdafx.h"
#include "Bass.h"
#include "BassVideo.h"
#include "windows.h"

/*
procedure DSPProc(handle: HDSP; channel: DWORD; buffer: Pointer; length: DWORD; user: Pointer); stdcall;
var dw, i : DWORD;
    buf1, buf2 : PBYTE;
begin
 buf1 := buffer;
 buf2 := AllocMem(length);
 dw := Bass_ChannelGetData(chan2, buf2, length);
 CopyMemory(Buf1, Buf2, dw);
 freemem(buf2);
end;
*/
DWORD chan1, chan2;

void CALLBACK DSPProc(HDSP handle, DWORD channel, void *buffer, DWORD length, void *user)
{
	BYTE * buf1;
	PBYTE buf2;
	buf1 = (BYTE *)buffer;
	buf2 = new BYTE[length];
	DWORD dw = BASS_ChannelGetData(chan2, buf2, length);
	if (dw == length)
	{
		CopyMemory(buf1, buf2, dw);
	}
	delete buf2;

}

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{
 	// TODO: Place code here.
    BASS_Init(-1, 44100, 0, 0, NULL);
	BassVideo_Init();
      

    chan1 = BassVideo_StreamCreateFile("D:\\Multimedia\\Video\\rythm of the rain.dat",  0, 0, NULL, NULL);
    chan2 = BassVideo_StreamCreateFile("D:\\Multimedia\\Video\\beatiful life.mpg",  0, 0, NULL, NULL);
	
	if (chan1 == 0) { return 1;} // need call free but i skip
	if (chan2 == 0) { return 1;} // need call free but i skip

	BassVideo_SetEndPosition(chan1, 30);
	BassVideo_SetEndPosition(chan2, 60);

    chan1 = BassVideo_Encoder_Create(chan1, L"C:\\test.wmv", Video_WMV, NULL);
	if (chan1 == 0) { return 1;} // need call free but i skip

    chan2 =  BassVideo_EncoderAudio(chan2, FALSE, NULL, NULL);
    if (chan2 == 0) { return 1;} // need call free but i skip

	BassVideo_Play(chan2);
	for (int i = 0; i < 10; i ++)
	{
		Sleep(100);
	}
	BASS_ChannelSetDSP(chan1, &DSPProc, NULL, 1);
    BassVideo_Play(chan1);

	MessageBox(0, "OK to exit", "hi!", 0);

	BassVideo_Free;
	BASS_Free;
 
	return 0;
}



