#ifdef __cplusplus
extern "C" {
#endif

#include <wtypes.h>
#include <windows.h>
#include <bass.h>

#ifndef BASSDEF
#define BASSDEF(f) WINAPI f
#endif`

#define    WM_VIDEO_8             100
#define    WM_VIDEO_9             101
#define    WM_AUTO_SELECT    -1 // for ASFConfig AudioCodec value


#define     WM_PROFILE               0
#define     WM_DONT_COMPRESS         1  // 0   false , 1   true
#define     WM_MULTI_PASS            2  // 0   false , 1   true
#define     WM_AUTOINDEX             3  // 0   false , 1   true
// //  WMPofiles8
#define     wmp_V80_255VideoPDA      0
#define     wmp_V80_150VideoPDA      1
#define     wmp_V80_28856VideoMBR    2
#define     wmp_V80_100768VideoMBR   3
#define     wmp_V80_288100VideoMBR   4
#define     wmp_V80_288Video         5
#define     wmp_V80_56Video          6
#define     wmp_V80_100Video         7
#define     wmp_V80_256Video         8
#define     wmp_V80_384Video         9
#define     wmp_V80_768Video         10
#define     wmp_V80_700NTSCVideo     11
#define     wmp_V80_1400NTSCVideo    12
#define     wmp_V80_384PALVideo      13
#define     wmp_V80_700PALVideo      14
#define     wmp_V80_288MonoAudio     15
#define     wmp_V80_288StereoAudio   16
#define     wmp_V80_32StereoAudio    17
#define     wmp_V80_48StereoAudio    18
#define     wmp_V80_64StereoAudio    19
#define     wmp_V80_96StereoAudio    20
#define     wmp_V80_128StereoAudio   21
#define     wmp_V80_288VideoOnly     22
#define     wmp_V80_56VideoOnly      23
#define     wmp_V80_FAIRVBRVideo     24
#define     wmp_V80_HIGHVBRVideo     25
#define     wmp_V80_BESTVBRVideo     26

// config
#define      BassVideo_Config_Renderer            0x100 // for BassVideo_GetConfig/SetConfig
#define      BassVideo_Congfig_WMASF_READER       0x101 // 0 = use WM_ASFReader else use Windows Media Source Filter

// action
#define      BassVideo_OpenDone        1 // Handle : HStream = 0 if failed , <> 0 if success
#define      BassVideo_Buffering       2 // param1 : 0 if buffering done, <> 0 if buffering in progress , param2 = buffer %
#define      BassVideo_FoundVideo      3 // Handle : HSTREAM tell the app must prepare the video windows & Handle
#define      BassVideo_EndStream       4
#define      BassVideo_DShow_Event     5
#define      BassVideo_WM_Move         6
#define      BassVideo_WM_Size         7
#define      BassVideo_WM_Paint        8
#define      BassVideo_WM_Mouse_Click  9
#define      BassVideo_WM_Mouse_Move   10
#define      BassVideo_PlayEvent       11

#define      BassVideo_Is_Play         1
#define      BassVideo_Is_Pause        2
#define      BassVideo_Is_Stop         3


#define      Video_WMV             1
#define      Video_AVI             0

#define      EncoderType_Video     0
#define      EncoderType_Audio     1
#define      EncoderType_WMASF     2
#define      Device_Video_Capture  3
#define      Device_Audio_Capture  4

// effect
#define EFFECT_POSITION_X           1
#define EFFECT_POSITION_Y           2
#define EFFECT_TEXT                 3
#define EFFECT_TEXT_COLOR           4
#define EFFECT_FONT                 5
#define EFFECT_PICTURE_HANDLE       6
#define EFFECT_PICTURE_ALPHA        7
#define EFFECT_PICTURE_TRANSPARENT  8
// vmr 9 effect
#define BASSVIDEO_VMR9_ZORDER       1
#define BASSVIDEO_VMR9_ALPHA        2
#define BASSVIDEO_VMR9_BGRCOLOR     3

      // flags :
#define       BASSVIDEO_AUTO_PAINT      2
#define       BASSVIDEO_AUTO_RESIZE     4
#define       BASSVIDEO_AUTO_MOVE       8
#define       BASSVIDEO_FILTERNAME      16
#define       BASSVIDEO_UNICODE         32
#define       BASSVIDEO_VIDEOEFFECT     64
#define       BASSVIDEO_DISABLE_VIDEO   128

 // video render option
#define BassVideo_Default            0
#define BassVideo_VMR9               1
#define BassVideo_VMR9_Windowless    2
#define BassVideo_EVR                3
#define BassVideo_Overlay            4
#define BassVideo_NOVIdeo            5

// media type
#define BASSVIDEO_MEDIA_UNKNOW       0
#define BASSVIDEO_MEDIA_AVI          2


#define     VIDEOTYPE_UNKNOW                                         00
    //Uncompressed RGB Video Subtypes
#define     VIDEOTYPE_RGB1                                           01 
#define     VIDEOTYPE_RGB4                                           02 
#define     VIDEOTYPE_RGB8                                           03 
#define     VIDEOTYPE_RGB555                                         04 
#define     VIDEOTYPE_RGB565                                         05 
#define     VIDEOTYPE_RGB24                                          06 
#define     VIDEOTYPE_RGB32                                          07 
#define     VIDEOTYPE_ARGB1555                                       08 
#define     VIDEOTYPE_ARGB32                                         09 
#define     VIDEOTYPE_ARGB4444                                       10 
#define     VIDEOTYPE_A2R10G10B10                                    11 
#define     VIDEOTYPE_A2B10G10R10                                    12 
    //YUV
#define     VIDEOTYPE_AYUV                                           13 
#define     VIDEOTYPE_YUY2                                           14 
#define     VIDEOTYPE_UYVY                                           15 
#define     VIDEOTYPE_IMC1                                           16 
#define     VIDEOTYPE_IMC3                                           17 
#define     VIDEOTYPE_IMC2                                           18 
#define     VIDEOTYPE_IMC4                                           19 
#define     VIDEOTYPE_YV12                                           20 
#define     VIDEOTYPE_NV12                                           21 
#define     VIDEOTYPE_Y411                                           22 
#define     VIDEOTYPE_Y41P                                           23 
#define     VIDEOTYPE_Y211                                           24 
#define     VIDEOTYPE_YVYU                                           25 
#define     VIDEOTYPE_YVU9                                           26 
#define     VIDEOTYPE_IF09                                           27 
    //Analog Video Subtypes
#define     VIDEOTYPE_AnalogVideo_NTSC_M                             28 
#define     VIDEOTYPE_AnalogVideo_PAL_B                              29 
#define     VIDEOTYPE_AnalogVideo_PAL_D                              30 
#define     VIDEOTYPE_AnalogVideo_PAL_G                              31 
#define     VIDEOTYPE_AnalogVideo_PAL_H                              32 
#define     VIDEOTYPE_AnalogVideo_PAL_I                              33 
#define     VIDEOTYPE_AnalogVideo_PAL_M                              34 
#define     VIDEOTYPE_AnalogVideo_PAL_N                              35 
#define     VIDEOTYPE_AnalogVideo_SECAM_B                            36 
#define     VIDEOTYPE_AnalogVideo_SECAM_D                            37 
#define     VIDEOTYPE_AnalogVideo_SECAM_G                            38 
#define     VIDEOTYPE_AnalogVideo_SECAM_H                            39 
#define     VIDEOTYPE_AnalogVideo_SECAM_K                            40 
#define     VIDEOTYPE_AnalogVideo_SECAM_K1                           41 
#define     VIDEOTYPE_AnalogVideo_SECAM_L                            42 
    //DirectX Video Acceleration Video Subtypes
#define     VIDEOTYPE_AI44                                           43 
#define     VIDEOTYPE_IA44                                           44 
    //DV Video Subtypes
#define     VIDEOTYPE_dvsl                                           45 
#define     VIDEOTYPE_dvsd                                           46 
#define     VIDEOTYPE_dvhd                                           47 
    //Professional Formats
#define     VIDEOTYPE_dv25                                           48 
#define     VIDEOTYPE_dv50                                           49 
#define     VIDEOTYPE_dvh1                                           50 
#define     VIDEOTYPE_DVCS                                           51 
    //Video Mixing Renderer Video Subtypes
    //VMR-7 Subtypes
#define     VIDEOTYPE_RGB32_D3D_DX7_RT                               52 
#define     VIDEOTYPE_RGB16_D3D_DX7_RT                               53 
#define     VIDEOTYPE_ARGB32_D3D_DX7_RT                              54 
#define     VIDEOTYPE_ARGB4444_D3D_DX7_RT                            55 
#define     VIDEOTYPE_ARGB1555_D3D_DX7_RT                            56 
    //VMR-9 Subtypes
#define     VIDEOTYPE_RGB32_D3D_DX9_RT                               57 
#define     VIDEOTYPE_RGB16_D3D_DX9_RT                               58 
#define     VIDEOTYPE_ARGB32_D3D_DX9_RT                              59 
#define     VIDEOTYPE_ARGB4444_D3D_DX9_RT                            60 
#define     VIDEOTYPE_ARGB1555_D3D_DX9_RT                            61 
    //Miscellaneous Video Subtypes
#define     VIDEOTYPE_CFCC                                           62 
#define     VIDEOTYPE_CLJR                                           63 
#define     VIDEOTYPE_CPLA                                           64 
#define     VIDEOTYPE_CLPL                                           65 
#define     VIDEOTYPE_IJPG                                           66 
#define     VIDEOTYPE_MDVF                                           67 
#define     VIDEOTYPE_MJPG                                           68 
#define     VIDEOTYPE_MPEG1Packet                                    69 
#define     VIDEOTYPE_MPEG1Payload                                   70 
#define     VIDEOTYPE_Overlay                                        71 
#define     VIDEOTYPE_Plum                                           72 
#define     VIDEOTYPE_QTJpeg                                         73 
#define     VIDEOTYPE_QTMovie                                        74 
#define     VIDEOTYPE_QTRle                                          75 
#define     VIDEOTYPE_QTRpza                                         76 
#define     VIDEOTYPE_QTSmc                                          77 
#define     VIDEOTYPE_TVMJ                                           78 
#define     VIDEOTYPE_VPVBI                                          79 
#define     VIDEOTYPE_VPVideo                                        80 
#define     VIDEOTYPE_WAKE                                           81

// structure
    typedef struct {
      int Bitrate;
      int Freq;
      int nChan;
      int wBitPerSample;
	} WMAudioFormat;

    typedef struct {
       int Version;
       BOOL Has_Audio;
       BOOL Has_Video;
       int VideoBitrate;
       BOOL useVideoVBR;
       int VBRQuality; // 0 -> 100
       int VideoCodec;
       int SrcVideoFrameHeight;
       int SrcVideoFrameWidth;
       int DestVideoFrameHeight;
       int DestVideoFrameWidth;
       int VideoQuality; // 0 -> 100
       int AudioCodec;
       int AudioCodecFormat;
       int AudioBitrate;
       int Audio_Frequency;
       int Audio_Channel;
       int Audio_Bits_Per_Sample;
	} ASFConfig;

	typedef struct {
		int AvgFrameRate;
		int FrameDraw;
		int FrameDrop;
	} BassVideoFrameInfo;
	
	typedef struct {
		DWORD MSG;
		int param1;
		int param2;
	} TMsg;

	typedef struct {
		DOUBLE AvgTimePerFrame;
		int Height ;
		int Width; 
		int FormatType;
		int VideoFormat;
		void * VideoFormat_GUID;
	} BassVideoInfo;

    typedef enum 
	{
		R43, 
		R169, 
		RSource, 
		RFree, 
		RCustom
	} ResizeType;

// callback
typedef BOOL (CALLBACK VIDEOPROC)(DWORD handle, DWORD action, DWORD param1, DWORD param2, void * user);
typedef BOOL (CALLBACK FILTERPROC)(DWORD handle, char * FilterName, void * Filter, void * user); 
typedef void (CALLBACK AudioEncoderCallBack)(DWORD chan, DWORD NewDatasize, void * user);
typedef BOOL (CALLBACK CallBackEnumEncoderFilter)(void * Filter, char * FilterName, char * FilterGuid, void * user);
typedef void (CALLBACK CallBackDraw)(DWORD chan, HDC dc, void * user);
HMODULE h;

// function
typedef BOOL (WINAPI * TBassVideo_Init)();
TBassVideo_Init _BassVideo_Init;

typedef void (WINAPI * TBassVideo_Free)();
TBassVideo_Free _BassVideo_Free;

typedef void (WINAPI * TBassVideo_StreamFree)(DWORD chan);
TBassVideo_StreamFree BassVideo_StreamFree;

typedef DWORD (WINAPI * TBassVideo_StreamCreateFile)(void * file, DWORD flags, DWORD bassflags, VIDEOPROC * callbackproc, void * user);
TBassVideo_StreamCreateFile BassVideo_StreamCreateFile;

typedef DWORD (WINAPI * TBassVideo_Play)(DWORD handle);
TBassVideo_Play BassVideo_Play;

typedef DWORD (WINAPI * TBassVideo_StreamCreateFileUser)(BASS_FILEPROCS * UserProc, DWORD MediaType, DWORD Flags,
														 DWORD BassFlags, VIDEOPROC * CallBackProc, void * user);
TBassVideo_StreamCreateFileUser BassVideo_StreamCreateFileUser; 

typedef DWORD (WINAPI * TBassVideo_StreamCreateFileMem)(void * data, QWORD datalength, DWORD MediaType, 
														DWORD Flags, DWORD BassFlags, VIDEOPROC * CallBackProc,
														void * user);
TBassVideo_StreamCreateFileMem BassVideo_StreamCreateFileMem;

typedef void (WINAPI * TBassVideo_SetConfig)(DWORD Option, DWORD value);
TBassVideo_SetConfig BassVideo_SetConfig;

typedef BOOL (WINAPI * TBassVideo_Stop)(DWORD chan);
TBassVideo_Stop BassVideo_Stop;

typedef BOOL (WINAPI * TBassVideo_Pause)(DWORD chan);
TBassVideo_Pause BassVideo_Pause;

typedef BOOL (WINAPI * TBassVideo_SetPosition)(DWORD chan, DOUBLE pos);
TBassVideo_SetPosition BassVideo_SetPosition;

typedef BOOL (WINAPI * TBassVideo_SetEndPosition)(DWORD chan, DOUBLE pos);
TBassVideo_SetPosition BassVideo_SetEndPosition;

typedef DOUBLE (WINAPI * TBassVideo_GetPosition)(DWORD chan);
TBassVideo_GetPosition BassVideo_GetPosition;

typedef DOUBLE (WINAPI * TBassVideo_GetLength)(DWORD chan);
TBassVideo_GetLength BassVideo_GetLength;

typedef BOOL (WINAPI * TBassVideo_SetEventNotify)(DWORD chan, HWND hwnd, int lMsg, int lInstanceData);
TBassVideo_SetEventNotify BassVideo_SetEventNotify;

typedef BOOL (WINAPI * TBassVideo_GetEvent)(DWORD chan, long * lEventCode, long * lParam1, long * lParam2, DWORD msTimeout);
TBassVideo_GetEvent BassVideo_GetEvent;

typedef void (WINAPI * TBassVideo_SetVideoWindow)(DWORD chan, HWND VideoWindowHandle, RECT * VideoRect, int VideoNum);
TBassVideo_SetVideoWindow BassVideo_SetVideoWindow;

typedef void (WINAPI * TBassVideo_Repaint)(DWORD chan, HWND WinHandle, HDC DC, int VideoNum);
TBassVideo_Repaint BassVideo_Repaint;

typedef void (WINAPI * TBassVideo_WindowResize)(DWORD chan, RECT * VideoRect, int VideoNum);
TBassVideo_WindowResize BassVideo_WindowResize;

typedef void (WINAPI * TBassVideo_WindowMove)(DWORD chan, DWORD Msg, WPARAM wParam, LPARAM lParam, int VideoNum);
TBassVideo_WindowMove BassVideo_WindowMove;

typedef HRESULT (WINAPI * TBassVideo_SetRatio)(DWORD chan, ResizeType Value, DOUBLE custom, int VideoNum);
TBassVideo_SetRatio BassVideo_SetRatio;

typedef DWORD (WINAPI * TBassVideo_SetChannel)(DWORD chan, DWORD newChan);
TBassVideo_SetChannel BassVideo_SetChannel;

typedef DWORD (WINAPI * TBassVideo_AddFile)(DWORD OldChan, void * newFile, DWORD Flags, DWORD BassFlags, 
											VIDEOPROC * callbackproc, void * user);
TBassVideo_AddFile BassVideo_AddFile;

typedef DWORD (WINAPI * TBassVideo_GetVersion)();
TBassVideo_GetVersion BassVideo_GetVersion;

typedef char * (WINAPI * TBassVideo_EventToString)(int Event);
TBassVideo_EventToString BassVideo_EventToString;

typedef BOOL (WINAPI * TBassVideo_AddVideo)(DWORD chan, HWND ParentHandle, RECT * Rect, DWORD Flags);
TBassVideo_AddVideo BassVideo_AddVideo;

typedef void * (WINAPI * TBassVideo_GetGraph)(DWORD chan);
TBassVideo_GetGraph BassVideo_GetGraph;

typedef BOOL (WINAPI * TBassVideo_FrameStep)(DWORD chan);
TBassVideo_FrameStep BassVideo_FrameStep;

typedef BOOL (WINAPI * TBassVideo_SetColor)(DWORD chan, int Color, FLOAT Value, int VideoNum, DWORD Flags);
TBassVideo_SetColor BassVideo_SetColor;

typedef BOOL (WINAPI * TBassVideo_GetColorRange)(DWORD chan, int Color, int VideoNum, DWORD Flags, 
												 FLOAT * CMax, FLOAT * CMin, FLOAT * CDef);
TBassVideo_GetColorRange BassVideo_GetColorRange;

typedef BOOL (WINAPI * TBassVideo_CaptureBitmap)(void * SourceFile, DOUBLE CaptureTime, void * BitmapOutput, DWORD Flags);
TBassVideo_CaptureBitmap BassVideo_CaptureBitmap;

typedef void (WINAPI * TBassVideo_GetVideoInfo)(DWORD chan, int * height, int * width);
TBassVideo_GetVideoInfo BassVideo_GetVideoInfo;

typedef BOOL (WINAPI * TBassVideo_EnumFilter)(DWORD chan, FILTERPROC * callbackproc, void * user);
TBassVideo_EnumFilter BassVideo_EnumFilter;

typedef BOOL (WINAPI * TBassVideo_HasFilterPropertyPage)(DWORD chan, void * Filter, DWORD Flags);
TBassVideo_HasFilterPropertyPage BassVideo_HasFilterPropertyPage;

typedef BOOL (WINAPI * TBassVideo_ShowFilterPropertyPage)(DWORD chan, void * Filter, HWND parenthandle, DWORD Flags);
TBassVideo_ShowFilterPropertyPage BassVideo_ShowFilterPropertyPage;

typedef  BOOL(WINAPI * TBassVideo_SaveGraphFile)(DWORD chan, void * FileName, DWORD Flags);
TBassVideo_SaveGraphFile BassVideo_SaveGraphFile;

typedef void (WINAPI * TBassVideo_CloseWindow)(DWORD chan, int VideoNum);
TBassVideo_CloseWindow BassVideo_CloseWindow;

typedef HWND (WINAPI * TBassVideo_GetVideoWindow)(DWORD chan, int vidNum);
TBassVideo_GetVideoWindow BassVideo_GetVideoWindow;

typedef BOOL (WINAPI * TBassVideo_SetTempoValue)(DWORD chan, DWORD value);
TBassVideo_SetTempoValue BassVideo_SetTempoValue;

typedef BOOL (WINAPI * TBassVideo_SetTempoEnable)(DWORD chan, BOOL value);
TBassVideo_SetTempoEnable BassVideo_SetTempoEnable;

typedef int (WINAPI * TBassVideo_GetTempoValue)(DWORD chan);
TBassVideo_GetTempoValue BassVideo_GetTempoValue;

typedef  BOOL (WINAPI * TBassVideo_GetTempoEnable)(DWORD chan);
TBassVideo_GetTempoEnable BassVideo_GetTempoEnable;

// new 2.4.1.0
typedef  BOOL (WINAPI * TBassVideo_SetPitchValue)(DWORD chan, DWORD value);
TBassVideo_SetPitchValue BassVideo_SetPitchValue;

typedef BOOL (WINAPI * TBassVideo_SetPitchEnable)(DWORD chan, BOOL value);
TBassVideo_SetPitchEnable BassVideo_SetPitchEnable;

typedef  int (WINAPI * TBassVideo_GetPitchValue)(DWORD chan);
TBassVideo_GetPitchValue BassVideo_GetPitchValue;

typedef BOOL (WINAPI * TBassVideo_GetPitchEnable)(DWORD chan);
TBassVideo_GetPitchEnable BassVideo_GetPitchEnable;

typedef BOOL (WINAPI * TBassVideo_GetInfo)(DWORD chan, BassVideoInfo * info);
TBassVideo_GetInfo BassVideo_GetInfo;


typedef BOOL (WINAPI * TBassVideo_GetFrameInfo)(DWORD chan, BassVideoFrameInfo * info);
TBassVideo_GetFrameInfo BassVideo_GetFrameInfo;

typedef DWORD (WINAPI * TBassVideo_EncoderAudio)(DWORD chan, BOOL VideoPreview, 
												 AudioEncoderCallBack * DataProc, void * user);
TBassVideo_EncoderAudio BassVideo_EncoderAudio;

typedef BOOL (WINAPI * TBassVideo_AddVideo2)(DWORD chan, HWND ParentHandle, int L, int T, int R, int B, DWORD Flags);
TBassVideo_AddVideo2 BassVideo_AddVideo2;
// end new 2.4.1.0

// 2.4.1.1
typedef DWORD (WINAPI * TBassVideo_EncoderVideo)(void * fin, void * fout, int VideoType, DWORD flags, void * VideoCodec, 
												 void * AudioCodec, VIDEOPROC * VidProc, void * user); 
TBassVideo_EncoderVideo BassVideo_EncoderVideo;

typedef BOOL (WINAPI * TBassVideo_EnumEncoder)(int EncoderType, CallBackEnumEncoderFilter CallBack, void * user);
TBassVideo_EnumEncoder BassVideo_EnumEncoder;

typedef void * (WINAPI * TBassVideo_CreateEncoder)(void * FilterGUID);
TBassVideo_CreateEncoder BassVideo_CreateEncoder;

typedef BOOL (WINAPI * TBassVideo_ConfigEncoderFilter)(DWORD chan, int EncoderType , HWND parent);
TBassVideo_ConfigEncoderFilter BassVideo_ConfigEncoderFilter;

typedef BOOL (WINAPI * TBassVideo_ConfigFilter)(int FilterType, char * FilterName, HWND ParentHandle);
TBassVideo_ConfigFilter BassVideo_ConfigFilter;

// 2.4.1.2
typedef int (WINAPI * TBassVideo_Effect_AddText)(DWORD chan, WCHAR * text, int x, int y, char * fontname, 
										  int fontheight, int fontwidth, DWORD fontcolor, DWORD fontstyle);
TBassVideo_Effect_AddText BassVideo_Effect_AddText;

typedef int (WINAPI * TBassVideo_Effect_AddText2)(DWORD chan, WCHAR * text, int x, int y, DWORD hfont, DWORD fontcolor);
TBassVideo_Effect_AddText2 BassVideo_Effect_AddText2;

typedef BOOL (WINAPI * TBassVideo_Effect_Set_Draw_CallBack)(DWORD chan, CallBackDraw * CallBackfunction , void * user);
TBassVideo_Effect_Set_Draw_CallBack BassVideo_Effect_Set_Draw_CallBack;

typedef BOOL (WINAPI * TBassVideo_Effect_Remove)(DWORD chan, int hText);
TBassVideo_Effect_Remove BassVideo_Effect_Remove;

typedef DWORD (WINAPI * TBassVideo_DVD_StreamCreate)(WCHAR * dvdpath, DWORD flags, DWORD bassflags, 
													 VIDEOPROC * vidproc, void * user);
TBassVideo_DVD_StreamCreate BassVideo_DVD_StreamCreate;

typedef BOOL (WINAPI * TBassVideo_DVD_ShowMenu)(DWORD chan);
TBassVideo_DVD_ShowMenu BassVideo_DVD_ShowMenu;

typedef BOOL (WINAPI * TBassVideo_DVD_MouseMove)(DWORD chan, LPARAM lParam);
TBassVideo_DVD_MouseMove BassVideo_DVD_MouseMove;

typedef BOOL (WINAPI * TBassVideo_DVD_MouseClick)(DWORD chan, LPARAM lParam);
TBassVideo_DVD_MouseClick BassVideo_DVD_MouseClick;

typedef BOOL (WINAPI * TBassVideo_DVD_EnableCaptions)(DWORD chan, BOOL CaptionEnable);
TBassVideo_DVD_EnableCaptions BassVideo_DVD_EnableCaptions;

typedef BOOL (WINAPI * TBassVideo_DVD_ShowTitle)(DWORD chan);
TBassVideo_DVD_ShowTitle BassVideo_DVD_ShowTitle;

typedef BOOL (WINAPI * TBassVideo_DVD_SaveBookMarks)(DWORD chan, WCHAR * FileName, WCHAR * Name);
TBassVideo_DVD_SaveBookMarks BassVideo_DVD_SaveBookMarks;

typedef BOOL (WINAPI * TBassVideo_DVD_RestoreBookMarks)(DWORD chan, WCHAR * FileName, WCHAR * Name);
TBassVideo_DVD_RestoreBookMarks BassVideo_DVD_RestoreBookMarks;

typedef int (WINAPI * TBassVideo_DVD_GetTitleCount)(DWORD chan);
TBassVideo_DVD_GetTitleCount BassVideo_DVD_GetTitleCount;

typedef DWORD (WINAPI * TBassVideo_DVD_GetChapterCount)(DWORD chan, DWORD title);
TBassVideo_DVD_GetChapterCount BassVideo_DVD_GetChapterCount;

typedef BOOL (WINAPI * TBassVideo_DVD_Play)(DWORD chan, int title, int chapter, DOUBLE time);
TBassVideo_DVD_Play BassVideo_DVD_Play;

typedef BOOL (WINAPI * TBassVideo_DVD_SetPlayRate)(DWORD chan, DOUBLE Rate);
TBassVideo_DVD_SetPlayRate BassVideo_DVD_SetPlayRate;

typedef BOOL (WINAPI * TBassVideo_DVD_PlayNextChapter)(DWORD chan);
TBassVideo_DVD_PlayNextChapter BassVideo_DVD_PlayNextChapter;

typedef BOOL (WINAPI * TBassVideo_DVD_PlayPrevChapter)(DWORD chan);
TBassVideo_DVD_PlayPrevChapter BassVideo_DVD_PlayPrevChapter;

typedef BOOL (WINAPI * TBassVideo_DVD_RePlayChapter)(DWORD chan);
TBassVideo_DVD_RePlayChapter BassVideo_DVD_RePlayChapter;

typedef BOOL (WINAPI * TBassVideo_DVD_PlayTitleInTime)(DWORD chan, int title, DOUBLE from_time, DOUBLE to_time);
TBassVideo_DVD_PlayTitleInTime BassVideo_DVD_PlayTitleInTime;

typedef BOOL (WINAPI * TBassVideo_DVD_PlayChapterAndStop)(DWORD chan, int title, int chapter, int num);
TBassVideo_DVD_PlayChapterAndStop BassVideo_DVD_PlayChapterAndStop;

typedef BOOL (WINAPI * TBassVideo_DVD_GetAudioLanguageCount)(DWORD Chan, DWORD * LangCount, DWORD * CurrentLang);
TBassVideo_DVD_GetAudioLanguageCount BassVideo_DVD_GetAudioLanguageCount;

typedef WCHAR * (WINAPI * TBassVideo_DVD_GetAudioLanguage)(DWORD chan, DWORD LangIndex);
TBassVideo_DVD_GetAudioLanguage BassVideo_DVD_GetAudioLanguage;

typedef BOOL (WINAPI * TBassVideo_DVD_SetAudioLanguage)(DWORD chan, DWORD LangIndex);
TBassVideo_DVD_SetAudioLanguage BassVideo_DVD_SetAudioLanguage;

typedef BOOL (WINAPI * TBassVideo_DVD_GetSubtitleCount)(DWORD chan, DWORD * MaxSub, DWORD * CurrentSub, BOOL * isSubShow);
TBassVideo_DVD_GetSubtitleCount BassVideo_DVD_GetSubtitleCount;

typedef WCHAR * (WINAPI * TBassVideo_DVD_GetSubtitleName)(DWORD chan, DWORD LangIndex);
TBassVideo_DVD_GetSubtitleName BassVideo_DVD_GetSubtitleName;

typedef BOOL (WINAPI * TBassVideo_DVD_SetSubtitle)(DWORD chan, DWORD LangIndex);
TBassVideo_DVD_SetSubtitle BassVideo_DVD_SetSubtitle;

typedef BOOL (WINAPI * TBassVideo_DVD_EnableSubtitle)(DWORD chan, BOOL Enable);
TBassVideo_DVD_EnableSubtitle BassVideo_DVD_EnableSubtitle;

typedef BOOL (WINAPI * TBassVideo_DVD_SelectParentalLevel)(DWORD chan, DWORD Level);
TBassVideo_DVD_SelectParentalLevel BassVideo_DVD_SelectParentalLevel;

typedef BOOL (WINAPI * TBassVideo_DVD_GetAngleCount)(DWORD chan, DWORD * Langlemax, DWORD * CurrentAngle);
TBassVideo_DVD_GetAngleCount BassVideo_DVD_GetAngleCount;

typedef BOOL (WINAPI * TBassVideo_DVD_SetCurrentAngle)(DWORD chan, DWORD CurrentAngle);
TBassVideo_DVD_SetCurrentAngle BassVideo_DVD_SetCurrentAngle;

typedef BOOL (WINAPI * TBassVideo_Capture_EnumDevice)(int DeviceType, void * CallBack, void * user);
TBassVideo_Capture_EnumDevice BassVideo_Capture_EnumDevice;

typedef int (WINAPI * TBassVideo_Capture_StreamCreate)(void * Video_Device, void * Audio_Device, BOOL isFilterName);
TBassVideo_Capture_StreamCreate BassVideo_Capture_StreamCreate;

typedef DWORD (WINAPI * TBassVideo_Capture_Start)(int handle, DWORD Flags, DWORD BassFlags, 
												  VIDEOPROC * VidProc, void * user);
TBassVideo_Capture_Start BassVideo_Capture_Start;

typedef BOOL (WINAPI * TBassVideo_Capture_ConfigDevice)(int handle, int Device, HWND parent);
TBassVideo_Capture_ConfigDevice BassVideo_Capture_ConfigDevice;

typedef BOOL (WINAPI * TBassVideo_Capture_ConfigDevicePin)(int handle, int Device, HWND parent);
TBassVideo_Capture_ConfigDevicePin BassVideo_Capture_ConfigDevicePin;

typedef BOOL (WINAPI * TBassVideo_Encoder_SetWMSetting)(DWORD chan, DWORD setting, DWORD value);
TBassVideo_Encoder_SetWMSetting BassVideo_Encoder_SetWMSetting;

typedef BOOL (WINAPI * TBassVideo_Encoder_GetWMSettingCount)(int SettingType, int &CodecCount, int &FormatCount);
TBassVideo_Encoder_GetWMSettingCount BassVideo_Encoder_GetWMSettingCount;

typedef BOOL (WINAPI * TBassVideo_Encoder_GetWMSetting)(int SettingType, int Codec, int Format, void * value);
TBassVideo_Encoder_GetWMSetting BassVideo_Encoder_GetWMSetting;

typedef DWORD (WINAPI * TBassVideo_Encoder_Create)(DWORD chan, WCHAR * FOut, int OutputType, void * EncoderSetting);
TBassVideo_Encoder_Create BassVideo_Encoder_Create;
// end of 2.4.1.2 new

// 2,4,1,3
typedef int (WINAPI * TBassVideo_Effect_AddPicture)(DWORD chan, HBITMAP pictureHandle, int x, int y, int alpha, DWORD transparentcolor);
TBassVideo_Effect_AddPicture BassVideo_Effect_AddPicture;

typedef BOOL (WINAPI * TBassVideo_Effect_SetInfo)(DWORD chan, int hEffect, int setting, void * value);
TBassVideo_Effect_SetInfo BassVideo_Effect_SetInfo;

// VMR9 effect
typedef int (WINAPI * TBassVideo_VMR9Effect_Create)(HWND : hwnd);
TBassVideo_VMR9Effect_Create BassVideo_VMR9Effect_Create;

typedef DWORD (WINAPI * TBassVideo_VMR9Effect_AddFile)(int hEffect, void * file, DWORD flags, DWORD bassflags, VIDEOPROC * callbackproc, void * user);
TBassVideo_VMR9Effect_AddFile BassVideo_VMR9Effect_AddFile;

typedef DWORD (WINAPI * TBassVideo_VMR9Effect_AddURL)(int hEffect, void * file, DWORD flags, DWORD bassflags, VIDEOPROC * callbackproc, void * user);
TBassVideo_VMR9Effect_AddURL BassVideo_VMR9Effect_AddURL;

typedef void (WINAPI * TBassVideo_VMR9Effect_Free)(int handle);
TBassVideo_VMR9Effect_Free BassVideo_VMR9Effect_Free;

typedef BOOL (WINAPI * TBassVideo_VMR9Effect_Remove)(int hEffect, DWORD chan);
TBassVideo_VMR9Effect_Remove BassVideo_VMR9Effect_Remove;

typedef BOOL (WINAPI * TBassVideo_VMR9Effect_SetInfo)(int hEffect, DWORD chan, int info, void * value);
TBassVideo_VMR9Effect_SetInfo BassVideo_VMR9Effect_SetInfo;

// init - free

BOOL BassVideo_Init()
{
	h = LoadLibrary("BassVideo.dll");
	_BassVideo_Init = (TBassVideo_Init) GetProcAddress(h, TEXT("BassVideo_Init"));
    if (NULL == _BassVideo_Init) return FALSE;

	_BassVideo_Free = (TBassVideo_Free) GetProcAddress(h, "BassVideo_Free");
    BassVideo_StreamCreateFile = (TBassVideo_StreamCreateFile) GetProcAddress(h, "BassVideo_StreamCreateFile");
	BassVideo_Play = (TBassVideo_Play) GetProcAddress(h, "BassVideo_Play");

    BassVideo_StreamCreateFileUser = (TBassVideo_StreamCreateFileUser) GetProcAddress(h, "BassVideo_StreamCreateFileUser");
    BassVideo_StreamCreateFileMem = (TBassVideo_StreamCreateFileMem) GetProcAddress(h, "BassVideo_StreamCreateFileMem");
    BassVideo_SetConfig = (TBassVideo_SetConfig) GetProcAddress(h, "BassVideo_SetConfig");
    BassVideo_Stop = (TBassVideo_Stop) GetProcAddress(h, "BassVideo_Stop");
    BassVideo_Pause = (TBassVideo_Pause) GetProcAddress(h, "BassVideo_Pause");
    BassVideo_SetPosition = (TBassVideo_SetPosition) GetProcAddress(h, "BassVideo_SetPosition");
    BassVideo_GetPosition = (TBassVideo_GetPosition) GetProcAddress(h, "BassVideo_GetPosition");
    BassVideo_GetLength = (TBassVideo_GetLength) GetProcAddress(h, "BassVideo_GetLength");
    BassVideo_SetEventNotify = (TBassVideo_SetEventNotify) GetProcAddress(h, "BassVideo_SetEventNotify");
    BassVideo_GetEvent = (TBassVideo_GetEvent) GetProcAddress(h, "BassVideo_GetEvent");
    BassVideo_SetVideoWindow = (TBassVideo_SetVideoWindow) GetProcAddress(h, "BassVideo_SetVideoWindow");
    BassVideo_Repaint = (TBassVideo_Repaint) GetProcAddress(h, "BassVideo_Repaint");
    BassVideo_WindowResize = (TBassVideo_WindowResize) GetProcAddress(h, "BassVideo_WindowResize");
    BassVideo_WindowMove = (TBassVideo_WindowMove) GetProcAddress(h, "BassVideo_WindowMove");
    BassVideo_SetRatio = (TBassVideo_SetRatio) GetProcAddress(h, "BassVideo_SetRatio");
    BassVideo_SetChannel = (TBassVideo_SetChannel) GetProcAddress(h, "BassVideo_SetChannel");
    BassVideo_AddFile = (TBassVideo_AddFile) GetProcAddress(h, "BassVideo_AddFile");
    BassVideo_GetVersion = (TBassVideo_GetVersion) GetProcAddress(h, "BassVideo_GetVersion");
    BassVideo_EventToString = (TBassVideo_EventToString) GetProcAddress(h, "BassVideo_EventToString");
    BassVideo_AddVideo = (TBassVideo_AddVideo) GetProcAddress(h, "BassVideo_AddVideo");
    BassVideo_GetGraph = (TBassVideo_GetGraph) GetProcAddress(h, "BassVideo_GetGraph");
    BassVideo_FrameStep = (TBassVideo_FrameStep) GetProcAddress(h, "BassVideo_FrameStep");
    BassVideo_SetColor = (TBassVideo_SetColor) GetProcAddress(h, "BassVideo_SetColor");
    BassVideo_GetColorRange = (TBassVideo_GetColorRange) GetProcAddress(h, "BassVideo_GetColorRange");
    BassVideo_CaptureBitmap = (TBassVideo_CaptureBitmap) GetProcAddress(h, "BassVideo_CaptureBitmap");
    BassVideo_GetVideoInfo = (TBassVideo_GetVideoInfo) GetProcAddress(h, "BassVideo_GetVideoInfo");
    BassVideo_EnumFilter = (TBassVideo_EnumFilter) GetProcAddress(h, "BassVideo_EnumFilter");
    BassVideo_HasFilterPropertyPage = (TBassVideo_HasFilterPropertyPage) GetProcAddress(h, "BassVideo_HasFilterPropertyPage");
    BassVideo_ShowFilterPropertyPage = (TBassVideo_ShowFilterPropertyPage) GetProcAddress(h, "BassVideo_ShowFilterPropertyPage");
    BassVideo_SaveGraphFile = (TBassVideo_SaveGraphFile) GetProcAddress(h, "BassVideo_SaveGraphFile");
    BassVideo_CloseWindow = (TBassVideo_CloseWindow) GetProcAddress(h, "BassVideo_CloseWindow");
    BassVideo_GetVideoWindow = (TBassVideo_GetVideoWindow) GetProcAddress(h, "BassVideo_GetVideoWindow");
    BassVideo_SetTempoValue = (TBassVideo_SetTempoValue) GetProcAddress(h, "BassVideo_SetTempoValue");
    BassVideo_SetTempoEnable = (TBassVideo_SetTempoEnable) GetProcAddress(h, "BassVideo_SetTempoEnable");
    BassVideo_GetTempoValue = (TBassVideo_GetTempoValue) GetProcAddress(h, "BassVideo_GetTempoValue");
    BassVideo_GetTempoEnable = (TBassVideo_GetTempoEnable) GetProcAddress(h, "BassVideo_GetTempoEnable");
    BassVideo_SetPitchValue = (TBassVideo_SetPitchValue) GetProcAddress(h, "BassVideo_SetPitchValue");
    BassVideo_SetPitchEnable = (TBassVideo_SetPitchEnable) GetProcAddress(h, "BassVideo_SetPitchEnable");
    BassVideo_GetPitchValue = (TBassVideo_GetPitchValue) GetProcAddress(h, "BassVideo_GetPitchValue");
    BassVideo_GetPitchEnable = (TBassVideo_GetPitchEnable) GetProcAddress(h, "BassVideo_GetPitchEnable");
    BassVideo_GetInfo = (TBassVideo_GetInfo) GetProcAddress(h, "BassVideo_GetInfo");
    BassVideo_GetFrameInfo = (TBassVideo_GetFrameInfo) GetProcAddress(h, "BassVideo_GetFrameInfo");
    BassVideo_EncoderAudio = (TBassVideo_EncoderAudio) GetProcAddress(h, "BassVideo_EncoderAudio");
    BassVideo_AddVideo2 = (TBassVideo_AddVideo2) GetProcAddress(h, "BassVideo_AddVideo2");
	BassVideo_StreamFree = (TBassVideo_StreamFree) GetProcAddress(h, "BassVideo_StreamFree");
    BassVideo_EncoderVideo = (TBassVideo_EncoderVideo) GetProcAddress(h, "BassVideo_EncoderVideo");
    BassVideo_EnumEncoder = (TBassVideo_EnumEncoder) GetProcAddress(h, "BassVideo_EnumEncoder");
    BassVideo_CreateEncoder = (TBassVideo_CreateEncoder) GetProcAddress(h, "BassVideo_CreateEncoder");
    BassVideo_ConfigEncoderFilter = (TBassVideo_ConfigEncoderFilter) GetProcAddress(h, "BassVideo_ConfigEncoderFilter");
    BassVideo_ConfigFilter = (TBassVideo_ConfigFilter) GetProcAddress(h, "BassVideo_ConfigFilter");
//2.4.1.2
    BassVideo_Effect_AddText = (TBassVideo_Effect_AddText) GetProcAddress(h, "BassVideo_Effect_AddText");
    BassVideo_Effect_AddText2 = (TBassVideo_Effect_AddText2) GetProcAddress(h, "BassVideo_Effect_AddText2");
    BassVideo_Effect_Set_Draw_CallBack = (TBassVideo_Effect_Set_Draw_CallBack) GetProcAddress(h, "BassVideo_Effect_Set_Draw_CallBack");
    BassVideo_Effect_Remove = (TBassVideo_Effect_Remove) GetProcAddress(h, "BassVideo_Effect_Remove");
    BassVideo_DVD_StreamCreate = (TBassVideo_DVD_StreamCreate) GetProcAddress(h, "BassVideo_DVD_StreamCreate");
    BassVideo_DVD_ShowMenu = (TBassVideo_DVD_ShowMenu) GetProcAddress(h, "BassVideo_DVD_ShowMenu");
    BassVideo_DVD_MouseMove = (TBassVideo_DVD_MouseMove) GetProcAddress(h, "BassVideo_DVD_MouseMove");
    BassVideo_DVD_MouseClick = (TBassVideo_DVD_MouseClick) GetProcAddress(h, "BassVideo_DVD_MouseClick");
    BassVideo_DVD_EnableCaptions = (TBassVideo_DVD_EnableCaptions) GetProcAddress(h, "BassVideo_DVD_EnableCaptions");
    BassVideo_DVD_ShowTitle = (TBassVideo_DVD_ShowTitle) GetProcAddress(h, "BassVideo_DVD_ShowTitle");
    BassVideo_DVD_SaveBookMarks = (TBassVideo_DVD_SaveBookMarks) GetProcAddress(h, "BassVideo_DVD_SaveBookMarks");
    BassVideo_DVD_RestoreBookMarks = (TBassVideo_DVD_RestoreBookMarks) GetProcAddress(h, "BassVideo_DVD_RestoreBookMarks");
    BassVideo_DVD_GetTitleCount = (TBassVideo_DVD_GetTitleCount) GetProcAddress(h, "BassVideo_DVD_GetTitleCount");
    BassVideo_DVD_GetChapterCount = (TBassVideo_DVD_GetChapterCount) GetProcAddress(h, "BassVideo_DVD_GetChapterCount");
    BassVideo_DVD_Play = (TBassVideo_DVD_Play) GetProcAddress(h, "BassVideo_DVD_Play");
    BassVideo_DVD_SetPlayRate = (TBassVideo_DVD_SetPlayRate) GetProcAddress(h, "BassVideo_DVD_SetPlayRate");
    BassVideo_DVD_PlayNextChapter = (TBassVideo_DVD_PlayNextChapter) GetProcAddress(h, "BassVideo_DVD_PlayNextChapter");
    BassVideo_DVD_PlayPrevChapter = (TBassVideo_DVD_PlayPrevChapter) GetProcAddress(h, "BassVideo_DVD_PlayPrevChapter");
    BassVideo_DVD_RePlayChapter = (TBassVideo_DVD_RePlayChapter) GetProcAddress(h, "BassVideo_DVD_RePlayChapter");
    BassVideo_DVD_PlayTitleInTime = (TBassVideo_DVD_PlayTitleInTime) GetProcAddress(h, "BassVideo_DVD_PlayTitleInTime");
    BassVideo_DVD_PlayChapterAndStop = (TBassVideo_DVD_PlayChapterAndStop) GetProcAddress(h, "BassVideo_DVD_PlayChapterAndStop");
    BassVideo_DVD_GetAudioLanguageCount = (TBassVideo_DVD_GetAudioLanguageCount) GetProcAddress(h, "BassVideo_DVD_GetAudioLanguageCount");
    BassVideo_DVD_GetAudioLanguage = (TBassVideo_DVD_GetAudioLanguage) GetProcAddress(h, "BassVideo_DVD_GetAudioLanguage");
    BassVideo_DVD_SetAudioLanguage = (TBassVideo_DVD_SetAudioLanguage) GetProcAddress(h, "BassVideo_DVD_SetAudioLanguage");
    BassVideo_DVD_GetSubtitleCount = (TBassVideo_DVD_GetSubtitleCount) GetProcAddress(h, "BassVideo_DVD_GetSubtitleCount");
    BassVideo_DVD_GetSubtitleName = (TBassVideo_DVD_GetSubtitleName) GetProcAddress(h, "BassVideo_DVD_GetSubtitleName");
    BassVideo_DVD_SetSubtitle = (TBassVideo_DVD_SetSubtitle) GetProcAddress(h, "BassVideo_DVD_SetSubtitle");
    BassVideo_DVD_EnableSubtitle = (TBassVideo_DVD_EnableSubtitle) GetProcAddress(h, "BassVideo_DVD_EnableSubtitle");
    BassVideo_DVD_SelectParentalLevel = (TBassVideo_DVD_SelectParentalLevel) GetProcAddress(h, "BassVideo_DVD_SelectParentalLevel");
    BassVideo_DVD_GetAngleCount = (TBassVideo_DVD_GetAngleCount) GetProcAddress(h, "BassVideo_DVD_GetAngleCount");
    BassVideo_DVD_SetCurrentAngle = (TBassVideo_DVD_SetCurrentAngle) GetProcAddress(h, "BassVideo_DVD_SetCurrentAngle");
    BassVideo_Capture_EnumDevice = (TBassVideo_Capture_EnumDevice) GetProcAddress(h, "BassVideo_Capture_EnumDevice");
    BassVideo_Capture_StreamCreate = (TBassVideo_Capture_StreamCreate) GetProcAddress(h, "BassVideo_Capture_StreamCreate");
    BassVideo_Capture_Start = (TBassVideo_Capture_Start) GetProcAddress(h, "BassVideo_Capture_Start");
    BassVideo_Capture_ConfigDevice = (TBassVideo_Capture_ConfigDevice) GetProcAddress(h, "BassVideo_Capture_ConfigDevice");
    BassVideo_Capture_ConfigDevicePin = (TBassVideo_Capture_ConfigDevicePin) GetProcAddress(h, "BassVideo_Capture_ConfigDevicePin");
    BassVideo_Encoder_SetWMSetting = (TBassVideo_Encoder_SetWMSetting) GetProcAddress(h, "BassVideo_Encoder_SetWMSetting");
	BassVideo_Encoder_GetWMSettingCount = (TBassVideo_Encoder_GetWMSettingCount) GetProcAddress(h, "BassVideo_Encoder_GetWMSettingCount");
	BassVideo_Encoder_GetWMSetting = (TBassVideo_Encoder_GetWMSetting) GetProcAddress(h, "BassVideo_Encoder_GetWMSetting");
	BassVideo_Encoder_Create = (TBassVideo_Encoder_Create) GetProcAddress(h, "BassVideo_Encoder_Create");
	BassVideo_SetEndPosition = (TBassVideo_SetEndPosition) GetProcAddress(h, "BassVideo_SetEndPosition");

    BassVideo_Effect_AddPicture = (TBassVideo_Effect_AddPicture) GetProcAddress(h, "BassVideo_Effect_AddPicture");
    BassVideo_Effect_SetInfo = (TBassVideo_Effect_SetInfo) GetProcAddress(h, "BassVideo_Effect_SetInfo");
    BassVideo_VMR9Effect_Create = (TBassVideo_VMR9Effect_Create) GetProcAddress(h, "BassVideo_VMR9Effect_Create");
    BassVideo_VMR9Effect_Free = (TBassVideo_VMR9Effect_Free) GetProcAddress(h, "BassVideo_VMR9Effect_Free");
    BassVideo_VMR9Effect_AddFile = (TBassVideo_VMR9Effect_AddFile) GetProcAddress(h, "BassVideo_VMR9Effect_AddFile");
    BassVideo_VMR9Effect_Remove = (TBassVideo_VMR9Effect_Remove) GetProcAddress(h, "BassVideo_VMR9Effect_Remove");
    BassVideo_VMR9Effect_SetInfo = (TBassVideo_VMR9Effect_SetInfo) GetProcAddress(h, "BassVideo_VMR9Effect_SetInfo");
    BassVideo_VMR9Effect_AddURL = (TBassVideo_VMR9Effect_AddURL) GetProcAddress(h, "BassVideo_VMR9Effect_AddURL");
//
	_BassVideo_Init();
	return TRUE;
}

void BassVideo_Free()
{
	_BassVideo_Free();
	FreeLibrary(h);
}

#ifdef __cplusplus
}
#endif


