//
// BassVideo 2.4.1.3 header file, copyright (c) 2007-2009 Kenshin1101
//
unit BassVideo;

interface

uses Windows, Bass;

const BASSVideoDLL = 'BassVideo.dll';
{
all bassvideo flags changes
}
      BASS_CTYPE_VIDEO_STREAM        = $11100;
      // CONFIG
      BASSVIDEO_CONFIG_RENDERER      = $100;
      // video render option
      BASSVIDEO_DEFAULT              = 0;
      BASSVIDEO_VMR9                 = 1;
      BASSVIDEO_VMR9_WINDOWLESS      = 2;
      BASSVIDEO_EVR                  = 3;
      BASSVIDEO_OVERLAY              = 4;
      BASSVIDEO_NOVIDEO              = 5;

      // CALLBACK ACTION
      BASSVIDEO_OPENDONE             = 1; // chan : DWORD = 0 if failed , <> 0 if success
      BASSVIDEO_BUFFERING            = 2; // param1 : 0 if buffering done, <> 0 if buffering in progress , param2 = buffer %
      BASSVIDEO_FOUNDVIDEO           = 3; // chan : DWORD tell the app must prepare the video windows & Handle
      BASSVIDEO_ENDSTREAM            = 4;
      BASSVIDEO_DSHOW_EVENT          = 5;
      BASSVIDEO_WM_MOVE              = 6;
      BASSVIDEO_WM_SIZE              = 7;
      BASSVIDEO_WM_PAINT             = 8;
      BASSVIDEO_WM_MOUSE_CLICK       = 9;
      BASSVIDEO_WM_MOUSE_MOVE        = 10;
      BASSVIDEO_PLAYEVENT            = 11;
      BASSVIDEO_SELECT_FILTER        = 12;

      //(BASSVIDEO_PLAYEVENT CALLBACK)
      BASSVIDEO_IS_PLAY              = 1;
      BASSVIDEO_IS_PAUSE             = 2;
      BASSVIDEO_IS_STOP              = 3;

      // flags :
      BASSVIDEO_AUTO_PAINT           = $200;  // (BASS_MUSIC_RAMP) ONLY NEED IN VMR9-WINDOWLESS MODE
      BASSVIDEO_AUTO_RESIZE          = $400;  //  BASS_MUSIC_RAMPS
      BASSVIDEO_AUTO_MOVE            = $800;  //  BASS_MUSIC_SURROUND
      BASSVIDEO_FILTERNAME           = $1000; //  BASS_MUSIC_SURROUND2
      BASSVIDEO_VIDEOEFFECT          = $2000; //  BASS_MUSIC_FT2MOD
      BASSVIDEO_DISABLE_VIDEO        = $4000; //  BASS_MUSIC_PT1MOD
      BASSVIDEO_FILTER_CALLBACK      = $10000;//  BASS_MUSIC_NONINTER

      COLOR_BRIGHTNESS               = 1;
      COLOR_CONTRAST                 = 2;
      COLOR_HUE                      = 3;
      COLOR_SATURATION               = 4;

      BASSVIDEO_MEDIA_UNKNOWN        = 0;
      BASSVIDEO_MEDIA_AVI            = 2;

      VIDEO_WMV                      = 1;
      VIDEO_AVI                      = 0;
      ENCODERTYPE_VIDEO              = 0;
      ENCODERTYPE_AUDIO              = 1;
      ENCODERTYPE_WMASF              = 2;
      DEVICE_VIDEO_CAPTURE           = 3;
      DEVICE_AUDIO_CAPTURE           = 4;
      // BUILD IN EFFECT
      EFFECT_POSITION_X              = 1;
      EFFECT_POSITION_Y              = 2;
      EFFECT_TEXT                    = 3;
      EFFECT_TEXT_COLOR              = 4;
      EFFECT_FONT                    = 5;
      EFFECT_PICTURE_HANDLE          = 6;
      EFFECT_PICTURE_ALPHA           = 7;
      EFFECT_PICTURE_TRANSPARENT     = 8;
      EFFECT_ENABLE                  = 9;
      EFFECT_BRIGHTNESS              = 10;
      // VMR9 - EXTERNAL EFFECT
      BASSVIDEO_VMR9_ZORDER          = 1;
      BASSVIDEO_VMR9_ALPHA           = 2;
      BASSVIDEO_VMR9_BGRCOLOR        = 3;

      // WMV ENCONDING
      WM_PROFILE                     = 0;
      WM_DONT_COMPRESS               = 1; // 0 = false , 1 = true
      WM_MULTI_PASS                  = 2; // 0 = false , 1 = true
      WM_AUTOINDEX                   = 3; // 0 = false , 1 = true

      WM_VIDEO_8                     = 100;
      WM_VIDEO_9                     = 101;
      WM_AUTO_SELECT                 = -1; // for ASFConfig AudioCodec value

      //  WMPofiles8 (for use in encoding video)
      wmp_V80_255VideoPDA            = 0;
      wmp_V80_150VideoPDA            = 1;
      wmp_V80_28856VideoMBR          = 2;
      wmp_V80_100768VideoMBR         = 3;
      wmp_V80_288100VideoMBR         = 4;
      wmp_V80_288Video               = 5;
      wmp_V80_56Video                = 6;
      wmp_V80_100Video               = 7;
      wmp_V80_256Video               = 8;
      wmp_V80_384Video               = 9;
      wmp_V80_768Video               = 10;
      wmp_V80_700NTSCVideo           = 11;
      wmp_V80_1400NTSCVideo          = 12;
      wmp_V80_384PALVideo            = 13;
      wmp_V80_700PALVideo            = 14;
      wmp_V80_288MonoAudio           = 15;
      wmp_V80_288StereoAudio         = 16;
      wmp_V80_32StereoAudio          = 17;
      wmp_V80_48StereoAudio          = 18;
      wmp_V80_64StereoAudio          = 19;
      wmp_V80_96StereoAudio          = 20;
      wmp_V80_128StereoAudio         = 21;
      wmp_V80_288VideoOnly           = 22;
      wmp_V80_56VideoOnly            = 23;
      wmp_V80_FAIRVBRVideo           = 24;
      wmp_V80_HIGHVBRVideo           = 25;
      wmp_V80_BESTVBRVideo           = 26;

type
     TWMAudioFormat = record
      Bitrate : integer;
      Freq : integer;
      nChan : integer;
      wBitPerSample : integer;
     end;
     PWMAudioFormat = ^TWMAudioFormat;

     PASFConfig = ^TASFConfig;
     TASFConfig = record
       Version : integer;
       Has_Audio : BOOL;
       Has_Video : BOOL;
       VideoBitrate : integer;
       useVideoVBR : BOOL;
       VBRQuality : integer; // 0 -> 100
       VideoCodec : integer;
       SrcVideoFrameHeight, SrcVideoFrameWidth : integer;
       DestVideoFrameHeight, DestVideoFrameWidth : integer;
       VideoQuality : integer; // 0 -> 100
       AudioCodec : integer;
       AudioCodecFormat : integer;
       AudioBitrate : integer;
       // for auto config audio
       Audio_Frequency : integer;
       Audio_Channel : integer;
       Audio_Bits_Per_Sample : integer;
       VideoPreview : BOOL;
       AudioPreView : BOOL; // for Capture graph only!!!
     end;

     HFilter = Pointer;

     HCapture = integer;

     TBassVideoFrameInfo = record
      AvgFrameRate    : integer;
      FrameDraw, FrameDrop : integer;
     end;

     TBassVideoInfo = record
      AvgTimePerFrame : Double;
      Height, Width : integer;
      FormatType : integer;
      VideoFormat : integer;
      VideoFormat_GUID : PGUID;
      HaveAudio : BOOL;
      HaveVideo : BOOL;
     end;

     TXMsg = record
        msg : DWORD;
        param1,
        param2 : LongInt;
     end;

// callback
     TCallBackDraw = procedure(chan : DWORD; DC : HDC; user : Pointer); stdcall;

     TResizeType = (R43, R169, RSource, RFree, RCustom);

     TCallBackEnumEncoderFilter = function(Filter : HFilter; FilterName,
                                           FilterGuid : PAnsiChar;user : Pointer) : BOOL; stdcall;

     TAudioEncoderCallBack = procedure(chan : DWORD; NewDatasize : DWORD; user : Pointer); stdcall;


     VIDEOPROC  = function(Handle : DWORD; Action, param1, param2 : DWORD; user : Pointer): BOOL; stdcall;
     {
        Handle : the channels handle
        Action :
           BassVideo_OpenDone     = 1; // chan : DWORD = 0 if failed , <> 0 if success
           BassVideo_Buffering    = 2; // param1 : 0 if buffering done, <> 0 if buffering in progress , param2 = buffer % // this for used in future
           BassVideo_FoundVideo   = 3; // chan : DWORD tell the app must prepare the video windows & Handle
     }
     FILTERPROC = function(Handle : DWORD; FilterName : PAnsiChar; Filter : Pointer; User : Pointer): BOOL; stdcall;
     {
        callback when enum filter
        FilterName : name of the DirectShow Filter
        Filter : Pointer of IBaseFilter

     }
// functions

function BassVideo_StreamCreateFile(FileName : Pointer; Flags : DWORD;
                                    Callback : Pointer; User : pointer): DWORD; stdcall; external BASSVideoDLL;

procedure BassVideo_Free; stdcall; external BassVideoDLL;

function BassVideo_SetEventNotify(chan: DWORD; hwnd: HWND; lMsg: Longint;
                                  lInstanceData: Longint): BOOL; stdcall; external BassVideoDLL;

function BassVideo_GetEvent(chan: DWORD; out lEventCode: Longint; out lParam1: Longint;
                            out lParam2: Longint; msTimeout: DWORD): BOOL; stdcall; external BassVideoDLL;

// for video windows function
procedure BassVideo_SetVideoWindow(chan: DWORD; VideoWindowHandle: THandle;
                                   var VideoRect: TRect; VideoNum: integer); stdcall; external BassVideoDLL;

procedure BassVideo_Repaint(chan: DWORD; WinHandle: HWND; DC: HDC;
                            VideoNum: integer); stdcall; external BassVideoDLL;

procedure BassVideo_WindowResize(chan: DWORD; var Rect: TRect; VideoNum: integer); stdcall; external BassVideoDLL;

procedure BassVideo_WindowMove(chan: DWORD; Msg: DWORD; wParam: Longint;
                               lParam: LongInt; VideoNum: integer); stdcall; external BassVideoDLL;

function BassVideo_SetRatio(chan: DWORD; Value: TResizeType; custom: Double;
                            VideoNum: integer ): HRESULT; stdcall; external BassVideoDLL;

function BassVideo_GetVersion: DWORD; stdcall; external BassVideoDLL;

function BassVideo_EventToString(Event: Longint): PAnsiChar; stdcall; external BassVideoDLL;

function BassVideo_GetGraph(chan: DWORD): Pointer; stdcall; external BassVideoDLL;

function BassVideo_FrameStep(chan: DWORD): BOOL; stdcall; external BassVideoDLL;

function BassVideo_SetColor(chan: DWORD; Color: integer; Value: single;
                            VideoNum: integer; Flags: DWORD): BOOL; stdcall; external BassVideoDLL;

function BassVideo_GetColorRange(chan: DWORD; Color: integer; VideoNum: integer;
                                 Flags: DWORD; var CMax, CMin, CDef: Single): BOOL; stdcall; external BassVideoDLL;

function BassVideo_CaptureBitmap(lpSourceFile: Pointer; CaptureTime: Double;
                                 BitmapOutput: Pointer; Flags: DWORD): BOOL; stdcall; external BassVideoDLL;

procedure BassVideo_GetVideoInfo(chan: DWORD; var height, width: integer); stdcall; external BassVideoDLL;

function BassVideo_EnumFilter(chan: DWORD; callback: Pointer; user: Pointer): BOOL; stdcall; external BassVideoDLL;

function BassVideo_HasFilterPropertyPage(chan: DWORD; Filter: Pointer; Flags: DWORD): BOOL; stdcall; external BassVideoDLL;

function BassVideo_ShowFilterPropertyPage(chan: DWORD; Filter: Pointer; parenthandle: HWND;
                                          Flags: DWORD): BOOL; stdcall; external BassVideoDLL;

function BassVideo_GetVideoWindow(chan: DWORD; vidnum: integer): HWND; stdcall; external BassVideoDLL;

function BassVideo_GetInfo(chan: DWORD; var info: TBassVideoInfo): BOOL; stdcall; external BassVideoDLL;

function BassVideo_GetFrameInfo(chan: DWORD; var info: TBassVideoFrameInfo): BOOL; stdcall; external BassVideoDLL;

function BassVideo_EnumEncoder(EncoderType: integer; CallBack: TCallBackEnumEncoderFilter;
                               user: Pointer): BOOL; stdcall; external BassVideoDLL;

function BassVideo_CreateEncoder(FilterGUID: PGUID): Pointer; stdcall; external BassVideoDLL;

function BassVideo_ConfigEncoderFilter(chan: DWORD; EncoderType: integer;
                                       parentHandle: HWND): BOOL; stdcall; external BassVideoDLL;

function BassVideo_ConfigFilter(FilterType: integer; FilterName: PAnsiChar;
                                parentHandle: HWND): BOOL; stdcall; external BassVideoDLL;

function BassVideo_DVD_ShowMenu(chan: DWORD): BOOL; stdcall; external BassVideoDLL;

function BassVideo_DVD_MouseMove(chan: DWORD; lParam: LPARAM): BOOL; stdcall; external BassVideoDLL;

function BassVideo_DVD_MouseClick(chan: DWORD; lParam: LPARAM): BOOL; stdcall; external BassVideoDLL;

function BassVideo_DVD_EnableCaptions(chan: DWORD; CaptionEnable: BOOL): BOOL; stdcall; external BassVideoDLL;

function BassVideo_DVD_ShowTitle(chan: DWORD): BOOL; stdcall; external BassVideoDLL;

function BassVideo_DVD_SaveBookMarks(chan: DWORD; FileName, Name: PWideChar): BOOL; stdcall; external BassVideoDLL;

function BassVideo_DVD_RestoreBookMarks(chan: DWORD; FileName, Name: PWideChar): BOOL; stdcall; external BassVideoDLL;

function BassVideo_DVD_GetTitleCount(chan: DWORD): integer; stdcall; external BassVideoDLL;

function BassVideo_DVD_GetChapterCount(chan: DWORD; title: DWORD): DWORD; stdcall; external BassVideoDLL;

function BassVideo_DVD_Play(chan: DWORD; title: integer; chapter: integer;
                            time: Double): BOOL; stdcall; external BassVideoDLL;

function BassVideo_DVD_SetPlayRate(chan: DWORD; Rate: Double): BOOL; stdcall; external BassVideoDLL;

function BassVideo_DVD_PlayNextChapter(chan: DWORD): BOOL; stdcall; external BassVideoDLL;

function BassVideo_DVD_PlayPrevChapter(chan: DWORD): BOOL; stdcall; external BassVideoDLL;

function BassVideo_DVD_RePlayChapter(chan: DWORD): BOOL; stdcall; external BassVideoDLL;

function BassVideo_DVD_PlayTitleInTime(chan: DWORD; title: integer;
                                       from_time, to_time: Double): BOOL; stdcall; external BassVideoDLL;

function BassVideo_DVD_PlayChapterAndStop(chan: DWORD;
                                          title, chapter, num: integer): BOOL; stdcall; external BassVideoDLL;

function BassVideo_DVD_GetAudioLanguageCount(chan: DWORD; var LangCount: DWORD;
                                             var CurrentLang: DWORD): BOOL; stdcall; external BassVideoDLL;

function BassVideo_DVD_GetAudioLanguage(chan: DWORD; LangIndex: DWORD): PWideChar; stdcall; external BassVideoDLL;

function BassVideo_DVD_SetAudioLanguage(chan: DWORD; LangIndex: DWORD): BOOL; stdcall; external BassVideoDLL;

function BassVideo_DVD_GetSubtitleCount(chan: DWORD; var MaxSub: DWORD;
                                        var CurrentSub: DWORD; var isSubShow: BOOL): BOOL; stdcall; external BassVideoDLL;

function BassVideo_DVD_GetSubtitleName(chan: DWORD; LangIndex: DWORD): PWideChar; stdcall; external BassVideoDLL;

function BassVideo_DVD_SetSubtitle(chan: DWORD; LangIndex: DWORD): BOOL; stdcall; external BassVideoDLL;

function BassVideo_DVD_EnableSubtitle(chan: DWORD; Enable: BOOL): BOOL; stdcall; external BassVideoDLL;

function BassVideo_DVD_SelectParentalLevel(chan: DWORD; Level: DWORD): BOOL; stdcall; external BassVideoDLL;

function BassVideo_DVD_GetAngleCount(chan: DWORD; var anglemax: DWORD;
                                     var CurrentAngle: DWORD): BOOL; stdcall; external BassVideoDLL;

function BassVideo_DVD_SetCurrentAngle(chan: DWORD; CurrentAngle: DWORD): BOOL; stdcall; external BassVideoDLL;

function BassVideo_Capture_EnumDevice(DeviceType: integer; CallBack: Pointer; user: Pointer): BOOL; stdcall; external BassVideoDLL;

function BassVideo_Capture_StreamCreate(Video_Device: Pointer; Audio_Device: Pointer;
                                        isFilterName: BOOL): HCapture; stdcall; external BassVideoDLL;

function BassVideo_Capture_Start(handle : HCapture; Flags : DWORD; VidProc : VIDEOPROC;
                                user : POinter) : DWORD; external BassVideoDLL;

function BassVideo_Capture_ConfigDevice(handle: HCapture; Device :integer;
                                        parent: HWND): BOOL; stdcall; external BassVideoDLL;

function BassVideo_Capture_ConfigDevicePin(handle: HCapture; Device :integer;
                                           parent: HWND): BOOL; stdcall; external BassVideoDLL;

function BassVideo_Encoder_SetWMSetting(chan: DWORD; setting: dword; value: dword): BOOL; stdcall; external BassVideoDLL;

function BassVideo_ReAddVideo(chan: DWORD): BOOL; stdcall; external BassVideoDLL;

function BassVideo_Encoder_GetWMSettingCount(SettingType: integer; var CodecCount: integer;
                                             var FormatCount: integer): BOOL; stdcall; external BassVideoDLL;

function BassVideo_Encoder_GetWMSetting(SettingType: integer; Codec: integer;
                                        Format: integer; var value: Pointer): BOOL; stdcall; external BassVideoDLL;

function BassVideo_Effect_AddText(chan: DWORD; text: PWideChar; x: integer;
                                  y: integer; fontname: PAnsiChar; fontheight: integer;
                                  fontwidth: integer; fontcolor: DWORD; fontstyle: DWORD): integer; stdcall; external BassVideoDLL;

function BassVideo_Effect_AddText2(chan: DWORD; text: PWideChar; x: integer;
                                   y: integer; hfont: DWORD; fontcolor: DWORD): integer; stdcall; external BassVideoDLL;

function BassVideo_Effect_AddPicture(chan: DWORD; pictureHandle: HBitmap; x: integer;
                                     y: integer; alpha: integer; transparentcolor: DWORD): integer; stdcall; external BassVideoDLL;

function BassVideo_Effect_Set_Draw_CallBack(chan: DWORD; CallBackFunction: Pointer;
                                            user: Pointer): BOOL; stdcall; external BassVideoDLL;

function BassVideo_Effect_Remove(chan: DWORD; hText: integer): BOOL; stdcall; external BassVideoDLL;

function BassVideo_Effect_SetInfo(chan: DWORD; hEffect: integer; setting: integer;
                                  value: Pointer): BOOL; stdcall; external BassVideoDLL;

// BassVideo VMR9 Effect
function BassVideo_VMR9Effect_Create(hwnd: HWND): integer; stdcall; external BassVideoDLL;

procedure BassVideo_VMR9Effect_Free(handle: integer); stdcall; external BassVideoDLL;

function BassVideo_VMR9Effect_Remove(hEffect: integer; chan: DWORD): BOOL; stdcall; external BassVideoDLL;

function BassVideo_VMR9Effect_SetInfo(hEffect: integer; chan: DWORD; info: integer;
                                      value: DWORD): BOOL; stdcall; external BassVideoDLL;

function BassVideo_VMR9Effect_AddFile(HEffect : integer; lpFileName : Pointer; Flags : DWORD;
                                      CallBackProc : VIDEOPROC; user : Pointer) : DWORD; stdcall; external BassVideoDLL;

function BassVideo_VMR9Effect_AddURL(HEffect : integer; lpFileName : Pointer; Flags: DWORD;
                                      CallBackProc : VIDEOPROC; user : Pointer) : DWORD; stdcall; external BassVideoDLL;

function BassVideo_VMR9Effect_AddFileEx(HEffect : integer; lpFileName : Pointer; Flags : DWORD;
                                      CallBackProc : VIDEOPROC; user : Pointer) : DWORD; stdcall; external BassVideoDLL;

function BassVideo_VMR9Effect_AddURLEx(HEffect : integer; lpFileName : Pointer; Flags: DWORD;
                                      CallBackProc : VIDEOPROC; user : Pointer) : DWORD; stdcall; external BassVideoDLL;

function BassVideo_SetPosition(handle: DWORD; pos: Double): BOOL; stdcall; external BassVideoDLL;
function BassVideo_GetPosition(handle: DWORD): Double; stdcall; external BassVideoDLL;
function BassVideo_GetLength(handle: DWORD): Double; stdcall; external BassVideoDLL;

function BassVideo_SetCallBack(chan : DWORD; callback, user : Pointer): BOOL; stdcall; external BassVideoDLL;

function BassVideo_SetTempoValue(chan, value : DWORD) : BOOL; stdcall; external BassVideoDLL;
function BassVideo_SetTempoEnable(chan : DWORD; value : BOOL) : BOOL; stdcall; external BassVideoDLL;
function BassVideo_GetTempoValue(chan : DWORD) : integer; stdcall; external BassVideoDLL;
function BassVideo_GetTempoEnable(chan : DWORD) : BOOL; stdcall; external BassVideoDLL;

// new 2.4.1.0
function BassVideo_SetPitchValue(chan, value : DWORD) : BOOL; stdcall; external BassVideoDLL;
function BassVideo_SetPitchEnable(chan : DWORD; value : BOOL) : BOOL; stdcall; external BassVideoDLL;
function BassVideo_GetPitchValue(chan : DWORD) : integer; stdcall; external BassVideoDLL;
function BassVideo_GetPitchEnable(chan : DWORD) : BOOL; stdcall; external BassVideoDLL;

function BassVideo_Stop(handle: DWORD) : BOOL; stdcall; external BassVideoDLL;
function BassVideo_Pause(handle: DWORD) : BOOL; stdcall; external BassVideoDLL;
function BassVideo_Play(handle: DWORD) : BOOL; stdcall; external BassVideoDLL;
procedure BassVideo_StreamFree(handle: DWORD); stdcall; external BassVideoDLL;

function BassVideo_StreamCreateFileEx(lpFileName : Pointer; Flags : DWORD;
                                     callback : Pointer; user : pointer): DWORD; stdcall; external BassVideoDLL;

function BassVideo_StreamCreateFileUserEx(UserProc : BASS_FILEPROCS;
                                          MediaType, Flags : DWORD;
                                          CallBackProc : VIDEOPROC; user : Pointer): DWORD; stdcall; external BassVideoDLL;

function BassVideo_StreamCreateFileMemEx(data :Pointer; datalength : int64;
                                         MediaType, Flags: DWORD; CallBackProc : VIDEOPROC;
                                         user : Pointer): DWORD; stdcall; external BassVideoDLL;

function BassVideo_StreamCreateURLEx(lpURL : Pointer; Flags : DWORD;
                                     callback : Pointer; user : pointer): DWORD; stdcall; external BassVideoDLL;

function BassVideo_StreamCreateFileUser(UserProc : BASS_FILEPROCS; MediaType, Flags : DWORD;
                                        CallBackProc : VIDEOPROC; user : Pointer): DWORD; stdcall; external BassVideoDLL;

function BassVideo_StreamCreateFileMem(data :Pointer; datalength : int64;
                                       MediaType, Flags: DWORD;
                                       CallBackProc : VIDEOPROC; user : Pointer): DWORD; stdcall; external BassVideoDLL;

function BassVideo_StreamCreateURL(lpURL : Pointer; Flags : DWORD;
                                   callback : Pointer; user : pointer): DWORD; stdcall; external BassVideoDLL;

function BassVideo_SetVideoBorderColor(chan : DWORD; color : DWORD): BOOL; stdcall; external BassVideoDLL;

function BassVideo_GetOutputChannel(chan : DWORD): DWORD; stdcall; external BassVideoDLL;

function BassVideo_Encoder_Create(chan : DWORD; FOut : PWideChar; OutputType : integer;
                                  EncoderSetting: Pointer): DWORD; stdcall; external BassVideoDLL;

function BassVideo_Audio_Effect_Apply(handle : integer; enable : BOOL; priority : integer): BOOL; stdcall; external BassVideoDLL;

procedure BassVideo_Audio_Effect_Free(handle : integer); stdcall; external BassVideoDLL;

function BassVideo_Audio_Effect_Create(chan : DWORD; effect : integer): integer; stdcall; external BassVideoDLL;

function BassVideo_SetSync(handle, chan : DWORD): BOOL; stdcall; external BassVideoDLL;

function BassVideo_Move(chan : DWORD; adstime : Double): BOOL; stdcall; external BassVideoDLL;

function BassVideo_AddVideo(chan : DWORD; ParentHandle : HWND;var Rect : TRECT; Flags : DWORD): BOOL; stdcall; external BassVideoDLL;
function BassVideo_AddVideo2(chan : DWORD; ParentHandle : HWND; L, T, R, B : integer; Flags : DWORD): BOOL; stdcall; external BassVideoDLL;
implementation

end.
