unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Bass, BassVideo, ExtCtrls, Menus, StdCtrls;

type
  TForm1 = class(TForm)
    PopupMenu1: TPopupMenu;
    OpenCapture1: TMenuItem;
    Label1: TLabel;
    N1: TMenuItem;
    Source1: TMenuItem;
    N431: TMenuItem;
    N1691: TMenuItem;
    Free1: TMenuItem;
    N2: TMenuItem;
    Exit1: TMenuItem;
    Captureas1: TMenuItem;
    SaveDialog: TSaveDialog;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure OpenCapture1Click(Sender: TObject);
    procedure Source1Click(Sender: TObject);
    procedure N431Click(Sender: TObject);
    procedure N1691Click(Sender: TObject);
    procedure Free1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Captureas1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses Unit2;

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
 Bass_Init(-1, 44100, 0, 0, nil);
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
 BassVideo_Free;
 Bass_Free;
end;

procedure TForm1.OpenCapture1Click(Sender: TObject);
var R : TRect;
begin
 if chan <> 0 then
  BassVideo_StreamFree(chan);
 Form2.ResetSelect;
 if chan = 0 then exit;
 R := ClientRect;
 BassVideo_SetVideoWindow(chan, Handle, R, 0);
 BassVideo_Play(chan);
end;

procedure TForm1.Source1Click(Sender: TObject);
var R : TRect;
begin
 BassVideo_SetRatio(chan, RSource, 0, 0);
 R := Form1.ClientRect;
 BassVideo_WindowResize(chan, R, 0);
end;

procedure TForm1.N431Click(Sender: TObject);
var R : TRect;
begin
 BassVideo_SetRatio(chan, R43, 0, 0);
 R := Form1.ClientRect;
 BassVideo_WindowResize(chan, R, 0);
end;

procedure TForm1.N1691Click(Sender: TObject);
var R : TRect;
begin
 BassVideo_SetRatio(chan, R169, 0, 0);
 R := Form1.ClientRect;
 BassVideo_WindowResize(chan, R, 0);
end;

procedure TForm1.Free1Click(Sender: TObject);
var R : TRect;
begin
 BassVideo_SetRatio(chan, RFree, 0, 0);
 R := Form1.ClientRect;
 BassVideo_WindowResize(chan, R, 0);
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
 Close;
end;

procedure TForm1.Captureas1Click(Sender: TObject);
var s : widestring;
    WmSetting : TASFConfig;
    info : BASS_CHANNELINFO;
begin
 if chan = 0 then exit;
 if not SaveDialog.Execute then exit;
 s := SaveDialog.FileName;
 WmSetting.Has_Audio := TRUE;
 WmSetting.Has_Video := TRUE;
 WmSetting.VideoBitrate := 1000 * 1000;
 WmSetting.useVideoVBR := FALSE;
 WmSetting.VBRQuality := 100; // or whatever value because we don't use VMR :)
 WmSetting.VideoCodec := WM_VIDEO_8; // use WM_VIDEO_9 to get more quality
 WmSetting.SrcVideoFrameHeight := 0;
 WmSetting.SrcVideoFrameWidth := 0;
 WmSetting.DestVideoFrameHeight := 0;
 WmSetting.DestVideoFrameWidth := 0;
 WmSetting.VideoQuality := 100;

 WmSetting.AudioCodec := WM_AUTO_SELECT ;
 WmSetting.AudioBitrate := 128 * 1000;

 Bass_ChannelGetInfo(chan, info);

 WmSetting.Audio_Frequency := info.freq;
 WmSetting.Audio_Channel := info.chans;
 if (info.flags and BASS_SAMPLE_8BITS) <> 0 then
   WmSetting.Audio_Bits_Per_Sample := 8
 else
   WmSetting.Audio_Bits_Per_Sample := 16;
 WmSetting.VideoPreview := TRUE;
 WmSetting.AudioPreView := TRUE;

 BassVideo_Stop(chan); // stop capture

 chan := BassVideo.BassVideo_Encoder_Create(chan, PWideChar(s), VIDEO_WMV, @WmSetting);
 if chan <> 0 then
  BassVideo_Play(chan)
 else
  ShowMessage('Capture Failed...');
end;

end.
