unit Unit2;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, BassVideo;

type
  TForm2 = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    ComboBox1: TComboBox;
    ComboBox2: TComboBox;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    procedure ComboBox1Change(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure ResetSelect;
  end;

var
  Form2: TForm2;
  chan : DWORD;
implementation

{$R *.dfm}
var Enumcap : BOOL = FALSE;
    hCap : integer;


procedure TForm2.ComboBox1Change(Sender: TObject);
var s1, s2 : PChar;
begin
 s1 := nil;
 if combobox1.ItemIndex <> -1 then
  s1 := PChar(Combobox1.Items[Combobox1.ItemIndex]);
 s2 := nil;
 if combobox2.ItemIndex <> -1 then
  s2 := PChar(Combobox2.Items[Combobox2.ItemIndex]);
 if hCap <> 0 then
  BassVideo_StreamFree(hCap);
 if (s1 = nil) and (s2 = nil) then exit;
 hCap := BassVideo_Capture_StreamCreate(s1, s2, TRUE);
end;

function CB(Filter : HFilter; FilterName, FilterGuid : PChar; user : Pointer) : BOOL; stdcall;
begin
  TCombobox(user).Items.Add(FilterName);
  result := TRUE;
end;
procedure TForm2.FormShow(Sender: TObject);
begin
 if EnumCap then exit;
 EnumCap := TRUE;
 BassVideo_Capture_EnumDevice(Device_Video_Capture, @cb, Combobox1);
 BassVideo_Capture_EnumDevice(Device_Audio_Capture, @cb, Combobox2);
end;

procedure TForm2.Button1Click(Sender: TObject);
begin
 if hCap <> 0 then
  BassVideo_Capture_ConfigDevice(hCap, Device_Video_Capture, Handle);
end;

procedure TForm2.Button3Click(Sender: TObject);
begin
 if hCap <> 0 then
  BassVideo_Capture_ConfigDevice(hCap, Device_Audio_Capture, Handle);
end;

procedure TForm2.Button2Click(Sender: TObject);
begin
 if hCap <> 0 then
  BassVideo_Capture_ConfigDevicePin(hCap, Device_Video_Capture, Handle);
end;

procedure TForm2.Button4Click(Sender: TObject);
begin
 if hCap <> 0 then
  BassVideo_Capture_ConfigDevicePin(hCap, Device_Audio_Capture, Handle);
end;

procedure TForm2.Button5Click(Sender: TObject);
begin
 if hCap = 0 then exit;
 chan := BassVideo_Capture_Start(hCap, BASSVIDEO_AUTO_RESIZE, nil, nil);
 close;
end;

procedure TForm2.Button6Click(Sender: TObject);
begin
 if hCap <> 0 then
  BassVideo_StreamFree(hCap);
 close;
end;

procedure TForm2.ResetSelect;
begin
 Combobox1.OnChange := nil;
 Combobox2.OnChange := nil;
 Combobox1.ItemIndex := -1;
 Combobox2.ItemIndex := -1;
 Combobox1.OnChange := ComboBox1Change;
 Combobox2.OnChange := ComboBox1Change;
 ShowModal;
end;

end.
