unit main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, Buttons, ToolWin, ExtCtrls, ImgList, Bass, BassVideo,
  Menus, XPMan;

type
  TForm1 = class(TForm)
    ImageList: TImageList;
    StatusBar1: TStatusBar;
    Panel1: TPanel;
    Label5: TLabel;
    ToolBar1: TToolBar;
    ToolButton1: TToolButton;
    ToolButton3: TToolButton;
    ToolButton2: TToolButton;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    ToolButton7: TToolButton;
    SpeedButton1: TSpeedButton;
    ToolButton8: TToolButton;
    ToolButton9: TToolButton;
    SoundLevel: TTrackBar;
    Pos: TTrackBar;
    Use_Effect: TCheckBox;
    ComboBox1: TComboBox;
    Memo1: TMemo;
    OpenDialog1: TOpenDialog;
    Panel2: TPanel;
    PopupMenu1: TPopupMenu;
    Source1: TMenuItem;
    N1: TMenuItem;
    Free1: TMenuItem;
    N431: TMenuItem;
    N1691: TMenuItem;
    XPManifest1: TXPManifest;
    Timer1: TTimer;
    Image1: TImage;
    tbTempo: TTrackBar;
    Label1: TLabel;
    CheckBox1: TCheckBox;
    Button1: TButton;
    Label2: TLabel;
    Button2: TButton;
    Label3: TLabel;
    tbPitch: TTrackBar;
    Label4: TLabel;
    CheckBox2: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure Source1Click(Sender: TObject);
    procedure Free1Click(Sender: TObject);
    procedure N431Click(Sender: TObject);
    procedure N1691Click(Sender: TObject);
    procedure SoundLevelChange(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure PosChange(Sender: TObject);
    procedure ToolButton3Click(Sender: TObject);
    procedure ToolButton4Click(Sender: TObject);
    procedure ToolButton2Click(Sender: TObject);
    procedure ToolButton1Click(Sender: TObject);
    procedure ToolButton5Click(Sender: TObject);
    procedure ToolButton9Click(Sender: TObject);
    procedure Use_EffectClick(Sender: TObject);
    procedure tbTempoChange(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure tbPitchChange(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  chan : DWORD;
  hEffect : integer;
implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
 if (not Bass_Init(-1, 44100, 0, Handle, nil))  then
  begin
   ShowMessage('Cannot init bass!');
   Application.Terminate;
  end;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
 BassVideo_Free;
 Bass_Free;
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
var R : TRect;
begin
 if Combobox1.ItemIndex = 2 then    // VMR9-WindowLess
  begin
   R := Panel2.ClientRect;
   BassVideo_SetVideoWindow(0, Panel2.Handle, R, 0);
  end;
 Bass_SetConfig(BassVideo_Config_Renderer, Combobox1.ItemIndex);
end;

function myVideoProc(Handle : DWORD; Action, param1, param2 : DWORD; user : Pointer): BOOL; stdcall;
begin
 result := FALSE;
 if action = BASSVIDEO_DSHOW_EVENT then
   Form1.Memo1.Lines.Add(BassVideo_EventToString(param1));
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
var R: TRect;
    info : TBassVideoInfo;
    flags : DWORD;
begin
 if not OpenDialog1.Execute then exit;

 if chan <> 0 then BassVideo_StreamFree(chan); // free old

 flags := BASSVIDEO_AUTO_RESIZE or BASS_SAMPLE_LOOP;

 if Use_Effect.Checked then flags := flags or BASSVIDEO_VIDEOEFFECT; // use bassvideo effect

 if Combobox1.ItemIndex = 2 then flags := flags or BASSVIDEO_AUTO_PAINT;    // VMR9-WindowLess

 chan := BassVideo_StreamCreateFileEx(PChar(opendialog1.FileName), flags, @myVideoProc, nil);
 if chan = 0 then
  begin
   showmessage('can''t open, error code = '  + inttostr(Bass_ErrorGetCode));
   exit;
  end;

 BassVideo_GetInfo(chan, info);
 if (info.Height <> 0) and (info.Width <> 0) then
 if info.HaveVideo then
  begin
   R := Panel2.ClientRect;
   BassVideo_SetVideoWindow(chan, Panel2.Handle, R, 0);
   BassVideo_SetCallBack(chan, @myVideoProc, nil);
  end;
 pos.OnChange := nil;
 pos.Position := 0;
 pos.Max := Round(BassVideo_GetLength(chan));
 pos.OnChange := poschange;
 SoundLevelChange(nil);
 if Use_Effect.Checked then
  begin
   hEffect := BassVideo_Effect_AddPicture(chan, Image1.Picture.Bitmap.Handle, 10, 10, 50,
                                         Image1.Picture.Bitmap.Canvas.Pixels[0, 0]);
   if hEffect = 0 then
    ShowMessage('Can''t add effect! Unknow error');
  end
 else hEffect := 0;
 BassVideo_Play(chan);
end;

procedure TForm1.Source1Click(Sender: TObject);
var R : TRect;
begin
 BassVideo_SetRatio(chan, RSource, 0, 0);
 R := Form1.Panel2.ClientRect;
 BassVideo_WindowResize(chan, R, 0);
end;

procedure TForm1.Free1Click(Sender: TObject);
var R : TRect;
begin
 BassVideo_SetRatio(chan, RFree, 0, 0);
 R := Form1.Panel2.ClientRect;
 BassVideo_WindowResize(chan, R, 0);
end;

procedure TForm1.N431Click(Sender: TObject);
var R : TRect;
begin
 BassVideo_SetRatio(chan, R43, 0, 0);
 R := Form1.Panel2.ClientRect;
 BassVideo_WindowResize(chan, R, 0);
end;

procedure TForm1.N1691Click(Sender: TObject);
var R : TRect;
begin
 BassVideo_SetRatio(chan, R169, 0, 0);
 R := Form1.Panel2.ClientRect;
 BassVideo_WindowResize(chan, R, 0);
end;

procedure TForm1.SoundLevelChange(Sender: TObject);
begin
 BASS_ChannelSetAttribute(chan, BASS_ATTRIB_VOL, SoundLevel.Position / SoundLevel.Max);
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var h, m, s : word;
    hm, mm, sm : word;
    p :  integer;
begin
 if (chan = 0) then exit;
 if Bass_ChannelIsActive(chan) <> BASS_ACTIVE_PLAYING then exit;

try
 pos.OnChange := nil;
 pos.Max := Round(BassVideo_GetLength(chan));
 pos.Frequency := pos.Max div 100;

 pos.Position := Round(BassVideo_GetPosition(chan));

 h := pos.Position div (60 * 60);
 m := (pos.Position - h * 60 * 60) div 60;
 s := (pos.Position - h * 60 * 60 - m * 60);

 hm := pos.Max div (60 * 60);
 mm := (pos.Max - hm * 60 * 60) div 60;
 sm := (pos.Max - hm * 60 * 60 - mm * 60);

 StatusBar1.Panels[0].Text := Format('%.3d:%.2d:%.2d / %.3d:%.2d:%.2d', [h, m ,s, hm, mm ,sm]);
except
end;
 pos.OnChange := posChange;

end;

procedure TForm1.PosChange(Sender: TObject);
begin
 BassVideo_SetPosition(chan, pos.Position);
end;

procedure TForm1.ToolButton3Click(Sender: TObject);
begin
 BassVideo_Play(chan);
end;

procedure TForm1.ToolButton4Click(Sender: TObject);
begin
 BassVideo_Stop(chan);
end;

procedure TForm1.ToolButton2Click(Sender: TObject);
begin
 BassVideo_Pause(chan);
end;

procedure TForm1.ToolButton1Click(Sender: TObject);
begin
 pos.Position := pos.Position - 5;
end;

procedure TForm1.ToolButton5Click(Sender: TObject);
begin
 pos.Position := pos.Position + 5;
end;

procedure TForm1.ToolButton9Click(Sender: TObject);
begin
 BassVideo_Pause(chan);
 BassVideo_FrameStep(chan);
end;

procedure TForm1.Use_EffectClick(Sender: TObject);
var B : BOOL;
begin
 if (chan <> 0) and (hEffect <> 0) then
  begin
   B := Use_Effect.Checked;
   BassVideo_Effect_SetInfo(chan, hEffect, EFFECT_ENABLE, @B);
  end;
end;

procedure TForm1.tbTempoChange(Sender: TObject);
begin
 Label2.Caption := Format('%.2fx', [tbTempo.Position / 1000]);
 if CheckBox1.Checked then
  BassVideo_SetTempoValue(chan, tbTempo.Position);
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
 tbTempo.Position := 1000;
end;

procedure TForm1.tbPitchChange(Sender: TObject);
begin
 Label3.Caption := Format('%.2fx', [tbPitch.Position / 1000]);
 if CheckBox2.Checked then
  BassVideo_SetPitchValue(chan, tbPitch.Position);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
 tbPitch.Position := 1000;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
 BassVideo_SetTempoEnable(Chan, CheckBox1.Checked);
 tbTempoChange(nil);
end;

procedure TForm1.CheckBox2Click(Sender: TObject);
begin
 BassVideo_SetPitchEnable(Chan, CheckBox2.Checked);
 tbPitchChange(nil);
end;

end.

